/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.aggregate;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.aggregate.Reporter;
import org.axonframework.test.aggregate.ResultValidator;
import org.axonframework.test.matchers.EqualFieldsMatcher;
import org.axonframework.test.matchers.FieldFilter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class ResultValidatorImpl
implements ResultValidator,
CommandCallback<Object, Object> {
    private final List<EventMessage<?>> publishedEvents;
    private final Reporter reporter = new Reporter();
    private final FieldFilter fieldFilter;
    private Object actualReturnValue;
    private Throwable actualException;

    public ResultValidatorImpl(List<EventMessage<?>> publishedEvents, FieldFilter fieldFilter) {
        this.publishedEvents = publishedEvents;
        this.fieldFilter = fieldFilter;
    }

    @Override
    public ResultValidator expectEvents(Object ... expectedEvents) {
        if (expectedEvents.length != this.publishedEvents.size()) {
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<EventMessage<?>> iterator = this.publishedEvents.iterator();
        for (Object expectedEvent : expectedEvents) {
            EventMessage<?> actualEvent = iterator.next();
            if (this.verifyEventEquality(expectedEvent, actualEvent.getPayload())) continue;
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator expectEventsMatching(Matcher<List<EventMessage<?>>> matcher) {
        if (!matcher.matches(this.publishedEvents)) {
            this.reporter.reportWrongEvent(this.publishedEvents, this.descriptionOf(matcher), this.actualException);
        }
        return this;
    }

    private StringDescription descriptionOf(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        return description;
    }

    @Override
    public ResultValidator expectSuccessfulHandlerExecution() {
        return this.expectReturnValueMatching(CoreMatchers.anything());
    }

    @Override
    public ResultValidator expectReturnValue(Object expectedReturnValue) {
        if (expectedReturnValue == null) {
            return this.expectReturnValueMatching(CoreMatchers.nullValue());
        }
        return this.expectReturnValueMatching(CoreMatchers.equalTo((Object)expectedReturnValue));
    }

    @Override
    public ResultValidator expectReturnValueMatching(Matcher<?> matcher) {
        if (matcher == null) {
            return this.expectReturnValueMatching(CoreMatchers.nullValue());
        }
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)description);
        } else if (!matcher.matches(this.actualReturnValue)) {
            this.reporter.reportWrongResult(this.actualReturnValue, (Description)description);
        }
        return this;
    }

    @Override
    public ResultValidator expectException(Class<? extends Throwable> expectedException) {
        return this.expectException(CoreMatchers.instanceOf(expectedException));
    }

    @Override
    public ResultValidator expectException(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        if (this.actualException == null) {
            this.reporter.reportUnexpectedReturnValue(this.actualReturnValue, (Description)description);
        }
        if (!matcher.matches((Object)this.actualException)) {
            this.reporter.reportWrongException(this.actualException, (Description)description);
        }
        return this;
    }

    public void onSuccess(CommandMessage<?> commandMessage, Object result) {
        this.actualReturnValue = result;
    }

    public void onFailure(CommandMessage<?> commandMessage, Throwable cause) {
        this.actualException = cause;
    }

    public void assertValidRecording() {
        if (this.actualException instanceof Error) {
            throw (Error)this.actualException;
        }
        if (this.actualException instanceof FixtureExecutionException) {
            throw (FixtureExecutionException)((Object)this.actualException);
        }
    }

    private boolean verifyEventEquality(Object expectedEvent, Object actualEvent) {
        if (!expectedEvent.getClass().equals(actualEvent.getClass())) {
            return false;
        }
        EqualFieldsMatcher<Object> matcher = new EqualFieldsMatcher<Object>(expectedEvent, this.fieldFilter);
        if (!matcher.matches(actualEvent)) {
            this.reporter.reportDifferentEventContents(expectedEvent.getClass(), matcher.getFailedField(), matcher.getFailedFieldActualValue(), matcher.getFailedFieldExpectedValue());
        }
        return true;
    }
}

