/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.eventhandling.saga.ResourceInjector;
import org.axonframework.test.FixtureExecutionException;

public class AutowiredResourceInjector
implements ResourceInjector {
    private Iterable<?> resources;

    public AutowiredResourceInjector(Iterable<?> resources) {
        this.resources = resources;
    }

    public void injectResources(Object saga) {
        for (Method method : ReflectionUtils.methodsOf(saga.getClass())) {
            if (!this.isSetter(method)) continue;
            Class<?> requiredType = method.getParameterTypes()[0];
            for (Object resource : this.resources) {
                if (!requiredType.isInstance(resource)) continue;
                this.injectResource(saga, method, resource);
            }
        }
    }

    private void injectResource(Object saga, Method setterMethod, Object resource) {
        try {
            ReflectionUtils.ensureAccessible((AccessibleObject)setterMethod);
            setterMethod.invoke(saga, resource);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new FixtureExecutionException("An exception occurred while trying to inject a resource", e);
        }
    }

    private boolean isSetter(Method method) {
        return method.getParameterTypes().length == 1 && method.getName().startsWith("set");
    }
}

