/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.axonframework.test.matchers.AllFieldsFilter;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.MatcherExecutionException;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class EqualFieldsMatcher<T>
extends BaseMatcher<T> {
    private final T expected;
    private final FieldFilter filter;
    private Field failedField;
    private Object failedFieldExpectedValue;
    private Object failedFieldActualValue;

    public EqualFieldsMatcher(T expected) {
        this(expected, AllFieldsFilter.instance());
    }

    public EqualFieldsMatcher(T expected, FieldFilter filter) {
        this.expected = expected;
        this.filter = filter;
    }

    public boolean matches(Object item) {
        return this.expected.getClass().isInstance(item) && this.matchesSafely(item);
    }

    private boolean matchesSafely(Object actual) {
        return this.expected.getClass().equals(actual.getClass()) && this.fieldsMatch(this.expected.getClass(), this.expected, actual);
    }

    private boolean fieldsMatch(Class<?> aClass, Object expectedValue, Object actual) {
        boolean match = true;
        for (Field field : aClass.getDeclaredFields()) {
            if (!this.filter.accept(field)) continue;
            field.setAccessible(true);
            try {
                Object expectedFieldValue = field.get(expectedValue);
                Object actualFieldValue = field.get(actual);
                if (expectedFieldValue != null && actualFieldValue != null && expectedFieldValue.getClass().isArray()) {
                    if (Arrays.deepEquals(new Object[]{expectedFieldValue}, new Object[]{actualFieldValue})) continue;
                    this.failedField = field;
                    this.failedFieldExpectedValue = expectedFieldValue;
                    this.failedFieldActualValue = actualFieldValue;
                    return false;
                }
                if ((expectedFieldValue == null || expectedFieldValue.equals(actualFieldValue)) && (expectedFieldValue != null || actualFieldValue == null)) continue;
                this.failedField = field;
                this.failedFieldExpectedValue = expectedFieldValue;
                this.failedFieldActualValue = actualFieldValue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new MatcherExecutionException("Could not confirm object equality due to an exception", e);
            }
        }
        if (aClass.getSuperclass() != Object.class) {
            match = this.fieldsMatch(aClass.getSuperclass(), expectedValue, actual);
        }
        return match;
    }

    public Field getFailedField() {
        return this.failedField;
    }

    public Object getFailedFieldExpectedValue() {
        return this.failedFieldExpectedValue;
    }

    public Object getFailedFieldActualValue() {
        return this.failedFieldActualValue;
    }

    public void describeTo(Description description) {
        description.appendText(this.expected.getClass().getName());
        if (this.failedField != null) {
            description.appendText(" (failed on field '").appendText(this.failedField.getName()).appendText("')");
        }
    }
}

