/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.commandhandling.AggregateAnnotationCommandHandler;
import org.axonframework.commandhandling.AnnotationCommandHandlerAdapter;
import org.axonframework.commandhandling.AnnotationCommandTargetResolver;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.model.Aggregate;
import org.axonframework.commandhandling.model.AggregateNotFoundException;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.GenericDomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.eventsourcing.eventstore.TrackingEventStream;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.FixtureConfiguration;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.FixtureResourceParameterResolverFactory;
import org.axonframework.test.ResultValidator;
import org.axonframework.test.ResultValidatorImpl;
import org.axonframework.test.TestExecutor;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.IgnoreField;
import org.axonframework.test.matchers.MatchAllFieldFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GivenWhenThenTestFixture<T>
implements FixtureConfiguration<T>,
TestExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GivenWhenThenTestFixture.class);
    private final Class<T> aggregateType;
    private final SimpleCommandBus commandBus;
    private final List<MessageDispatchInterceptor<CommandMessage<?>>> commandDispatchInterceptors = new ArrayList();
    private final List<MessageHandlerInterceptor<CommandMessage<?>>> commandHandlerInterceptors = new ArrayList();
    private final EventStore eventStore;
    private Repository<T> repository;
    private String aggregateIdentifier;
    private Deque<DomainEventMessage<?>> givenEvents;
    private Deque<DomainEventMessage<?>> storedEvents;
    private List<EventMessage<?>> publishedEvents;
    private long sequenceNumber = 0L;
    private Aggregate<T> workingAggregate;
    private boolean reportIllegalStateChange = true;
    private boolean explicitCommandHandlersSet;
    private final List<FieldFilter> fieldFilters = new ArrayList<FieldFilter>();

    public GivenWhenThenTestFixture(Class<T> aggregateType) {
        this.commandBus = new SimpleCommandBus();
        this.eventStore = new RecordingEventStore();
        FixtureResourceParameterResolverFactory.clear();
        FixtureResourceParameterResolverFactory.registerResource(this.commandBus);
        FixtureResourceParameterResolverFactory.registerResource(this.eventStore);
        this.aggregateType = aggregateType;
        this.clearGivenWhenState();
    }

    @Override
    public FixtureConfiguration<T> registerRepository(EventSourcingRepository<T> eventSourcingRepository) {
        this.repository = new IdentifierValidatingRepository<T>(eventSourcingRepository);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerAggregateFactory(AggregateFactory<T> aggregateFactory) {
        return this.registerRepository(new EventSourcingRepository(aggregateFactory, this.eventStore));
    }

    @Override
    public synchronized FixtureConfiguration<T> registerAnnotatedCommandHandler(Object annotatedCommandHandler) {
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
        AnnotationCommandHandlerAdapter adapter = new AnnotationCommandHandlerAdapter(annotatedCommandHandler, ClasspathParameterResolverFactory.forClass(this.aggregateType));
        adapter.subscribe((CommandBus)this.commandBus);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandler(Class<?> payloadType, MessageHandler<CommandMessage<?>> commandHandler) {
        return this.registerCommandHandler(payloadType.getName(), commandHandler);
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandler(String commandName, MessageHandler<CommandMessage<?>> commandHandler) {
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
        this.commandBus.subscribe(commandName, commandHandler);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerInjectableResource(Object resource) {
        if (this.explicitCommandHandlersSet) {
            throw new FixtureExecutionException("Cannot inject resources after command handler has been created. Configure all resource before calling registerCommandHandler() or registerAnnotatedCommandHandler()");
        }
        FixtureResourceParameterResolverFactory.registerResource(resource);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandDispatchInterceptor(MessageDispatchInterceptor<CommandMessage<?>> commandDispatchInterceptor) {
        this.commandDispatchInterceptors.add(commandDispatchInterceptor);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandlerInterceptor(MessageHandlerInterceptor<CommandMessage<?>> commandHanderInterceptor) {
        this.commandHandlerInterceptors.add(commandHanderInterceptor);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilters.add(fieldFilter);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerIgnoredField(Class<?> declaringClass, String fieldName) {
        return this.registerFieldFilter(new IgnoreField(declaringClass, fieldName));
    }

    @Override
    public TestExecutor given(Object ... domainEvents) {
        return this.given(Arrays.asList(domainEvents));
    }

    @Override
    public TestExecutor givenNoPriorActivity() {
        return this.given(Collections.emptyList());
    }

    @Override
    public TestExecutor given(List<?> domainEvents) {
        this.ensureRepositoryConfiguration();
        this.clearGivenWhenState();
        try {
            Iterator<?> iterator = domainEvents.iterator();
            while (iterator.hasNext()) {
                Object event;
                Object payload = event = iterator.next();
                MetaData metaData = null;
                if (event instanceof Message) {
                    payload = ((Message)event).getPayload();
                    metaData = ((Message)event).getMetaData();
                }
                this.givenEvents.add((DomainEventMessage<?>)new GenericDomainEventMessage(this.aggregateType.getSimpleName(), this.aggregateIdentifier, this.sequenceNumber++, payload, (Map)metaData));
            }
        }
        catch (Exception e) {
            FixtureResourceParameterResolverFactory.clear();
        }
        return this;
    }

    @Override
    public TestExecutor givenCommands(Object ... commands) {
        return this.givenCommands(Arrays.asList(commands));
    }

    @Override
    public TestExecutor givenCommands(List<?> commands) {
        this.finalizeConfiguration();
        this.clearGivenWhenState();
        try {
            for (Object command : commands) {
                ExecutionExceptionAwareCallback callback = new ExecutionExceptionAwareCallback();
                this.commandBus.dispatch(GenericCommandMessage.asCommandMessage(command), (CommandCallback)callback);
                callback.assertSuccessful();
                this.givenEvents.addAll(this.storedEvents);
                this.storedEvents.clear();
            }
            this.publishedEvents.clear();
        }
        catch (Throwable e) {
            FixtureResourceParameterResolverFactory.clear();
            throw e;
        }
        return this;
    }

    @Override
    public ResultValidator when(Object command) {
        return this.when(command, (Map<String, ?>)MetaData.emptyInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultValidator when(Object command, Map<String, ?> metaData) {
        try {
            this.commandHandlerInterceptors.add(new AggregateRegisteringInterceptor());
            this.finalizeConfiguration();
            MatchAllFieldFilter fieldFilter = new MatchAllFieldFilter(this.fieldFilters);
            ResultValidatorImpl resultValidator = new ResultValidatorImpl(this.storedEvents, this.publishedEvents, fieldFilter);
            this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)command).andMetaData(metaData), (CommandCallback)resultValidator);
            this.detectIllegalStateChanges(fieldFilter);
            resultValidator.assertValidRecording();
            ResultValidatorImpl resultValidatorImpl = resultValidator;
            return resultValidatorImpl;
        }
        finally {
            FixtureResourceParameterResolverFactory.clear();
        }
    }

    private void ensureRepositoryConfiguration() {
        if (this.repository == null) {
            this.registerRepository(new EventSourcingRepository(this.aggregateType, this.eventStore));
        }
    }

    private void finalizeConfiguration() {
        this.registerAggregateCommandHandlers();
        this.registerCommandInterceptors();
        this.explicitCommandHandlersSet = true;
    }

    private void registerAggregateCommandHandlers() {
        this.ensureRepositoryConfiguration();
        if (!this.explicitCommandHandlersSet) {
            AggregateAnnotationCommandHandler handler = new AggregateAnnotationCommandHandler(this.aggregateType, this.repository, (CommandTargetResolver)new AnnotationCommandTargetResolver());
            handler.subscribe((CommandBus)this.commandBus);
        }
    }

    private void registerCommandInterceptors() {
        this.commandBus.setDispatchInterceptors(this.commandDispatchInterceptors);
        this.commandBus.setHandlerInterceptors(this.commandHandlerInterceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectIllegalStateChanges(MatchAllFieldFilter fieldFilter) {
        if (this.aggregateIdentifier != null && this.workingAggregate != null && this.reportIllegalStateChange) {
            DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
            try {
                Aggregate aggregate2 = this.repository.load(this.aggregateIdentifier);
                if (this.workingAggregate.isDeleted()) {
                    throw new AxonAssertionError("The working aggregate was considered deleted, but the Repository still contains a non-deleted copy of the aggregate. Make sure the aggregate explicitly marks itself as deleted in an EventHandler.");
                }
                this.assertValidWorkingAggregateState(aggregate2, fieldFilter);
            }
            catch (AggregateNotFoundException notFound) {
                if (!this.workingAggregate.isDeleted()) {
                    throw new AxonAssertionError("The working aggregate was not considered deleted, but the Repository cannot recover the state of the aggregate, as it is considered deleted there.");
                }
            }
            catch (Exception e) {
                logger.warn("An Exception occurred while detecting illegal state changes in {}.", (Object)this.workingAggregate.getClass().getName(), (Object)e);
            }
            finally {
                uow.rollback();
            }
        }
    }

    private void assertValidWorkingAggregateState(Aggregate<T> eventSourcedAggregate, MatchAllFieldFilter fieldFilter) {
        HashSet<ComparationEntry> comparedEntries = new HashSet<ComparationEntry>();
        if (!this.workingAggregate.rootType().equals(eventSourcedAggregate.rootType())) {
            throw new AxonAssertionError(String.format("The aggregate loaded based on the generated events seems to be of another type than the original.\nWorking type: <%s>\nEvent Sourced type: <%s>", this.workingAggregate.rootType().getName(), eventSourcedAggregate.rootType().getName()));
        }
        this.ensureValuesEqual(this.workingAggregate.invoke(Function.identity()), eventSourcedAggregate.invoke(Function.identity()), eventSourcedAggregate.rootType().getName(), comparedEntries, fieldFilter);
    }

    private void ensureValuesEqual(Object workingValue, Object eventSourcedValue, String propertyPath, Set<ComparationEntry> comparedEntries, FieldFilter fieldFilter) {
        if (ReflectionUtils.explicitlyUnequal((Object)workingValue, (Object)eventSourcedValue)) {
            throw new AxonAssertionError(String.format("Illegal state change detected! Property \"%s\" has different value when sourcing events.\nWorking aggregate value:     <%s>\nValue after applying events: <%s>", propertyPath, workingValue, eventSourcedValue));
        }
        if (workingValue != null && comparedEntries.add(new ComparationEntry(workingValue, eventSourcedValue)) && !ReflectionUtils.hasEqualsMethod(workingValue.getClass())) {
            for (Field field : ReflectionUtils.fieldsOf(workingValue.getClass())) {
                if (!fieldFilter.accept(field) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                ReflectionUtils.ensureAccessible((AccessibleObject)field);
                String newPropertyPath = propertyPath + "." + field.getName();
                Object workingFieldValue = ReflectionUtils.getFieldValue((Field)field, (Object)workingValue);
                Object eventSourcedFieldValue = ReflectionUtils.getFieldValue((Field)field, (Object)eventSourcedValue);
                this.ensureValuesEqual(workingFieldValue, eventSourcedFieldValue, newPropertyPath, comparedEntries, fieldFilter);
            }
        }
    }

    private void clearGivenWhenState() {
        this.storedEvents = new LinkedList();
        this.publishedEvents = new ArrayList();
        this.givenEvents = new LinkedList();
        this.sequenceNumber = 0L;
    }

    @Override
    public void setReportIllegalStateChange(boolean reportIllegalStateChange) {
        this.reportIllegalStateChange = reportIllegalStateChange;
    }

    @Override
    public CommandBus getCommandBus() {
        return this.commandBus;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventStore;
    }

    @Override
    public EventStore getEventStore() {
        return this.eventStore;
    }

    @Override
    public Repository<T> getRepository() {
        this.ensureRepositoryConfiguration();
        return this.repository;
    }

    private class ExecutionExceptionAwareCallback
    implements CommandCallback<Object, Object> {
        private FixtureExecutionException exception;

        private ExecutionExceptionAwareCallback() {
        }

        public void onSuccess(CommandMessage<?> commandMessage, Object result) {
        }

        public void onFailure(CommandMessage<?> commandMessage, Throwable cause) {
            this.exception = cause instanceof FixtureExecutionException ? (FixtureExecutionException)((Object)cause) : new FixtureExecutionException("Failed to execute givenCommands", cause);
        }

        public void assertSuccessful() {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    private class AggregateRegisteringInterceptor
    implements MessageHandlerInterceptor<CommandMessage<?>> {
        private AggregateRegisteringInterceptor() {
        }

        public Object handle(UnitOfWork<? extends CommandMessage<?>> unitOfWork, InterceptorChain interceptorChain) throws Exception {
            unitOfWork.onPrepareCommit(u -> {
                Set aggregates = (Set)u.getResource("ManagedAggregates");
                if (aggregates != null && aggregates.size() == 1) {
                    GivenWhenThenTestFixture.this.workingAggregate = (Aggregate)aggregates.iterator().next();
                }
            });
            return interceptorChain.proceed();
        }
    }

    private class RecordingEventStore
    implements EventStore {
        private RecordingEventStore() {
        }

        public DomainEventStream readEvents(String identifier) {
            if (GivenWhenThenTestFixture.this.aggregateIdentifier != null && !GivenWhenThenTestFixture.this.aggregateIdentifier.equals(identifier)) {
                throw new EventStoreException("You probably want to use aggregateIdentifier() on your fixture to get the aggregate identifier to use");
            }
            if (GivenWhenThenTestFixture.this.aggregateIdentifier == null) {
                GivenWhenThenTestFixture.this.aggregateIdentifier = identifier;
                this.injectAggregateIdentifier();
            }
            ArrayList allEvents = new ArrayList(GivenWhenThenTestFixture.this.givenEvents);
            allEvents.addAll(GivenWhenThenTestFixture.this.storedEvents);
            if (allEvents.isEmpty()) {
                throw new AggregateNotFoundException(identifier, "No 'given' events were configured for this aggregate, nor have any events been stored.");
            }
            return DomainEventStream.of(allEvents.iterator());
        }

        public void publish(List<? extends EventMessage<?>> events) {
            if (CurrentUnitOfWork.isStarted()) {
                CurrentUnitOfWork.get().onPrepareCommit(u -> this.doAppendEvents(events));
            } else {
                this.doAppendEvents(events);
            }
        }

        protected void doAppendEvents(List<? extends EventMessage<?>> events) {
            GivenWhenThenTestFixture.this.publishedEvents.addAll(events);
            events.stream().filter(DomainEventMessage.class::isInstance).map(e -> (DomainEventMessage)e).forEach(event -> {
                DomainEventMessage lastEvent;
                if (GivenWhenThenTestFixture.this.aggregateIdentifier == null) {
                    GivenWhenThenTestFixture.this.aggregateIdentifier = event.getAggregateIdentifier();
                    this.injectAggregateIdentifier();
                }
                if ((lastEvent = (DomainEventMessage)(GivenWhenThenTestFixture.this.storedEvents.isEmpty() ? GivenWhenThenTestFixture.this.givenEvents : GivenWhenThenTestFixture.this.storedEvents).peekLast()) != null) {
                    if (!lastEvent.getAggregateIdentifier().equals(event.getAggregateIdentifier())) {
                        throw new EventStoreException("Writing events for an unexpected aggregate. This could indicate that a wrong aggregate is being triggered.");
                    }
                    if (lastEvent.getSequenceNumber() != event.getSequenceNumber() - 1L) {
                        throw new EventStoreException(String.format("Unexpected sequence number on stored event. Expected %s, but got %s.", lastEvent.getSequenceNumber() + 1L, event.getSequenceNumber()));
                    }
                }
                GivenWhenThenTestFixture.this.storedEvents.add(event);
            });
        }

        private void injectAggregateIdentifier() {
            ArrayList oldEvents = new ArrayList(GivenWhenThenTestFixture.this.givenEvents);
            GivenWhenThenTestFixture.this.givenEvents.clear();
            for (DomainEventMessage oldEvent : oldEvents) {
                if (oldEvent.getAggregateIdentifier() == null) {
                    GivenWhenThenTestFixture.this.givenEvents.add(new GenericDomainEventMessage(oldEvent.getType(), GivenWhenThenTestFixture.this.aggregateIdentifier, oldEvent.getSequenceNumber(), oldEvent.getPayload(), (Map)oldEvent.getMetaData(), oldEvent.getIdentifier(), oldEvent.getTimestamp()));
                    continue;
                }
                GivenWhenThenTestFixture.this.givenEvents.add(oldEvent);
            }
        }

        public TrackingEventStream streamEvents(TrackingToken trackingToken) {
            throw new UnsupportedOperationException();
        }

        public Registration subscribe(Consumer<List<? extends EventMessage<?>>> eventProcessor) {
            return () -> true;
        }

        public Registration registerDispatchInterceptor(MessageDispatchInterceptor<EventMessage<?>> dispatchInterceptor) {
            return () -> true;
        }
    }

    private static class IdentifierValidatingRepository<T>
    implements Repository<T> {
        private final Repository<T> delegate;

        public IdentifierValidatingRepository(Repository<T> delegate) {
            this.delegate = delegate;
        }

        public Aggregate<T> newInstance(Callable<T> factoryMethod) throws Exception {
            return this.delegate.newInstance(factoryMethod);
        }

        public Aggregate<T> load(String aggregateIdentifier, Long expectedVersion) {
            Aggregate aggregate = this.delegate.load(aggregateIdentifier, expectedVersion);
            this.validateIdentifier(aggregateIdentifier, aggregate);
            return aggregate;
        }

        public Aggregate<T> load(String aggregateIdentifier) {
            Aggregate aggregate = this.delegate.load(aggregateIdentifier, null);
            this.validateIdentifier(aggregateIdentifier, aggregate);
            return aggregate;
        }

        private void validateIdentifier(String aggregateIdentifier, Aggregate<T> aggregate) {
            if (aggregateIdentifier != null && !aggregateIdentifier.equals(aggregate.identifier())) {
                throw new AssertionError((Object)String.format("The aggregate used in this fixture was initialized with an identifier different than the one used to load it. Loaded [%s], but actual identifier is [%s].\nMake sure the identifier passed in the Command matches that of the given Events.", aggregateIdentifier, aggregate.identifier()));
            }
        }
    }

    private static class ComparationEntry {
        private final Object workingObject;
        private final Object eventSourceObject;

        public ComparationEntry(Object workingObject, Object eventSourceObject) {
            this.workingObject = workingObject;
            this.eventSourceObject = eventSourceObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparationEntry that = (ComparationEntry)o;
            if (!this.eventSourceObject.equals(that.eventSourceObject)) {
                return false;
            }
            return this.workingObject.equals(that.workingObject);
        }

        public int hashCode() {
            int result = this.workingObject.hashCode();
            result = 31 * result + this.eventSourceObject.hashCode();
            return result;
        }
    }
}

