/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.test.AxonAssertionError;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;

public class Reporter {
    private static final String NEWLINE = System.getProperty("line.separator");

    public void reportDifferenceInStoredVsPublished(Collection<DomainEventMessage<?>> storedEvents, Collection<EventMessage<?>> publishedEvents, Throwable probableCause) {
        StringBuilder sb = new StringBuilder("The stored events do not match the published events.");
        this.appendEventOverview(sb, storedEvents, publishedEvents, "Stored events", "Published events");
        this.appendProbableCause(probableCause, sb);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportWrongEvent(Collection<?> actualEvents, Collection<?> expectedEvents, Throwable probableCause) {
        StringBuilder sb = new StringBuilder("The published events do not match the expected events");
        this.appendEventOverview(sb, expectedEvents, actualEvents, "Expected", "Actual");
        this.appendProbableCause(probableCause, sb);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportWrongEvent(Collection<?> actualEvents, StringDescription expectation, Throwable probableCause) {
        StringBuilder sb = new StringBuilder("The published events do not match the expected events.");
        sb.append("Expected :");
        sb.append(NEWLINE);
        sb.append(expectation);
        sb.append(NEWLINE);
        sb.append("But got");
        if (actualEvents.isEmpty()) {
            sb.append(" none");
        } else {
            sb.append(":");
        }
        for (Object publishedEvent : actualEvents) {
            sb.append(NEWLINE);
            sb.append(publishedEvent.getClass().getSimpleName());
            sb.append(": ");
            sb.append(publishedEvent.toString());
        }
        this.appendProbableCause(probableCause, sb);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportUnexpectedException(Throwable actualException, Description expectation) {
        StringBuilder sb = new StringBuilder("The command handler threw an unexpected exception");
        sb.append(NEWLINE).append(NEWLINE).append("Expected <").append(expectation.toString()).append("> but got <exception of type [").append(actualException.getClass().getSimpleName()).append("]>. Stack trace follows:").append(NEWLINE);
        this.writeStackTrace(actualException, sb);
        sb.append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportWrongResult(Object actualReturnValue, Description expectation) {
        StringBuilder sb = new StringBuilder("The command handler returned an unexpected value");
        sb.append(NEWLINE).append(NEWLINE).append("Expected <");
        sb.append(expectation.toString());
        sb.append("> but got <");
        this.describe(actualReturnValue, sb);
        sb.append(">").append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportUnexpectedReturnValue(Object actualReturnValue, Description description) {
        StringBuilder sb = new StringBuilder("The command handler returned normally, but an exception was expected");
        sb.append(NEWLINE).append(NEWLINE).append("Expected <");
        sb.append(description.toString());
        sb.append("> but returned with <");
        this.describe(actualReturnValue, sb);
        sb.append(">").append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportWrongException(Throwable actualException, Description description) {
        StringBuilder sb = new StringBuilder("The command handler threw an exception, but not of the expected type");
        sb.append(NEWLINE).append(NEWLINE).append("Expected <").append(description.toString()).append("> but got <exception of type [").append(actualException.getClass().getSimpleName()).append("]>. Stacktrace follows: ").append(NEWLINE);
        this.writeStackTrace(actualException, sb);
        sb.append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportDifferentEventContents(Class<?> eventType, Field field, Object actual, Object expected) {
        StringBuilder sb = new StringBuilder("One of the events contained different values than expected");
        sb.append(NEWLINE).append(NEWLINE).append("In an event of type [").append(eventType.getSimpleName()).append("], the property [").append(field.getName()).append("] ");
        if (!eventType.equals(field.getDeclaringClass())) {
            sb.append("(declared in [").append(field.getDeclaringClass().getSimpleName()).append("]) ");
        }
        sb.append("was not as expected.").append(NEWLINE).append("Expected <").append(this.nullSafeToString(expected)).append("> but got <").append(this.nullSafeToString(actual)).append(">").append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    private void appendProbableCause(Throwable probableCause, StringBuilder sb) {
        if (probableCause != null) {
            sb.append(NEWLINE);
            sb.append("A probable cause for the wrong chain of events is an exception that occurred while handling the command.");
            sb.append(NEWLINE);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            probableCause.printStackTrace(new PrintWriter(charArrayWriter));
            sb.append(charArrayWriter.toCharArray());
        }
    }

    private void writeStackTrace(Throwable actualException, StringBuilder sb) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        actualException.printStackTrace(pw);
        pw.flush();
        sb.append(new String(baos.toByteArray()));
    }

    private String nullSafeToString(Object value) {
        if (value == null) {
            return "<null>";
        }
        return value.toString();
    }

    private void describe(Object value, StringBuilder sb) {
        if (value == null) {
            sb.append("null");
        } else {
            sb.append(value.toString());
        }
    }

    private void appendEventOverview(StringBuilder sb, Collection<?> leftColumnEvents, Collection<?> rightColumnEvents, String leftColumnName, String rightColumnName) {
        ArrayList<String> actualTypes = new ArrayList<String>(rightColumnEvents.size());
        ArrayList<String> expectedTypes = new ArrayList<String>(leftColumnEvents.size());
        int largestExpectedSize = leftColumnName.length();
        for (Object event : rightColumnEvents) {
            actualTypes.add(this.payloadContentType(event));
        }
        for (Object event : leftColumnEvents) {
            String simpleName = this.payloadContentType(event);
            if (simpleName.length() > largestExpectedSize) {
                largestExpectedSize = simpleName.length();
            }
            expectedTypes.add(simpleName);
        }
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        sb.append(leftColumnName);
        this.pad(sb, leftColumnName.length(), largestExpectedSize, " ");
        sb.append("  |  ").append(rightColumnName).append(NEWLINE);
        this.pad(sb, 0, largestExpectedSize, "-");
        sb.append("--|--");
        this.pad(sb, 0, largestExpectedSize, "-");
        sb.append(NEWLINE);
        Iterator actualIterator = actualTypes.iterator();
        Iterator expectedIterator = expectedTypes.iterator();
        while (actualIterator.hasNext() || expectedIterator.hasNext()) {
            boolean difference;
            String expected = "";
            if (expectedIterator.hasNext()) {
                expected = (String)expectedIterator.next();
                sb.append(expected);
                this.pad(sb, expected.length(), largestExpectedSize, " ");
                difference = !actualIterator.hasNext();
            } else {
                this.pad(sb, 0, largestExpectedSize, " ");
                difference = true;
            }
            if (actualIterator.hasNext()) {
                String actual = (String)actualIterator.next();
                boolean bl = difference = difference || !actual.equals(expected);
                if (difference) {
                    sb.append(" <|> ");
                } else {
                    sb.append("  |  ");
                }
                sb.append(actual);
            } else {
                sb.append(" <|> ");
            }
            sb.append(NEWLINE);
        }
    }

    private String payloadContentType(Object event) {
        String simpleName = EventMessage.class.isInstance(event) ? ((EventMessage)event).getPayload().getClass().getName() : event.getClass().getName();
        return simpleName;
    }

    private void pad(StringBuilder sb, int currentLength, int targetLength, String character) {
        for (int t = currentLength; t < targetLength; ++t) {
            sb.append(character);
        }
    }
}

