/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.test.utils.CallbackBehavior;
import org.axonframework.test.utils.DefaultCallbackBehavior;

public class RecordingCommandBus
implements CommandBus {
    private ConcurrentMap<String, CommandHandler<?>> subscriptions = new ConcurrentHashMap();
    private List<CommandMessage<?>> dispatchedCommands = new ArrayList();
    private CallbackBehavior callbackBehavior = new DefaultCallbackBehavior();

    public void dispatch(CommandMessage<?> command) {
        this.dispatchedCommands.add(command);
    }

    public <R> void dispatch(CommandMessage<?> command, CommandCallback<R> callback) {
        this.dispatchedCommands.add(command);
        try {
            callback.onSuccess(this.callbackBehavior.handle(command.getPayload(), command.getMetaData()));
        }
        catch (Throwable throwable) {
            callback.onFailure(throwable);
        }
    }

    public <C> void subscribe(String commandName, CommandHandler<? super C> handler) {
        if (!this.subscriptions.containsKey(commandName)) {
            this.subscriptions.put(commandName, handler);
        }
    }

    public <C> boolean unsubscribe(String commandName, CommandHandler<? super C> handler) {
        return this.subscriptions.remove(commandName, handler);
    }

    public void clearCommands() {
        this.dispatchedCommands.clear();
    }

    public void clearSubscriptions() {
        this.subscriptions.clear();
    }

    public boolean isSubscribed(CommandHandler<?> commandHandler) {
        return this.subscriptions.containsValue(commandHandler);
    }

    public <C> boolean isSubscribed(String commandName, CommandHandler<? super C> commandHandler) {
        return this.subscriptions.containsKey(commandName) && ((CommandHandler)this.subscriptions.get(commandName)).equals(commandHandler);
    }

    public Map<String, CommandHandler<?>> getSubscriptions() {
        return this.subscriptions;
    }

    public List<CommandMessage<?>> getDispatchedCommands() {
        return this.dispatchedCommands;
    }

    public void setCallbackBehavior(CallbackBehavior callbackBehavior) {
        this.callbackBehavior = callbackBehavior;
    }
}

