/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.Message;
import org.axonframework.test.FixtureExecutionException;

@Priority(value=-2147483648)
public final class FixtureResourceParameterResolverFactory
implements ParameterResolverFactory {
    private static final ThreadLocal<List<Object>> RESOURCES = new ThreadLocal();

    public ParameterResolver createInstance(Annotation[] memberAnnotations, Class<?> parameterType, Annotation[] parameterAnnotations) {
        return new LazyParameterResolver(parameterType);
    }

    public static void registerResource(Object injectableResource) {
        if (RESOURCES.get() == null) {
            RESOURCES.set(new ArrayList());
        }
        if (!RESOURCES.get().contains(injectableResource)) {
            RESOURCES.get().add(injectableResource);
        }
    }

    public static void clear() {
        RESOURCES.remove();
    }

    private static class LazyParameterResolver
    implements ParameterResolver {
        private final Class<?> parameterType;

        public LazyParameterResolver(Class<?> parameterType) {
            this.parameterType = parameterType;
        }

        public Object resolveParameterValue(Message message) {
            List objects = (List)RESOURCES.get();
            if (objects != null) {
                for (Object resource : objects) {
                    if (!this.parameterType.isInstance(resource)) continue;
                    return resource;
                }
            }
            throw new FixtureExecutionException("No resource of type [" + this.parameterType.getName() + "] has been registered. It is required for one of the handlers being executed.");
        }

        public boolean matches(Message message) {
            return RESOURCES.get() != null;
        }
    }
}

