/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandDispatchInterceptor;
import org.axonframework.commandhandling.gateway.GatewayProxyFactory;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.saga.GenericSagaFactory;
import org.axonframework.saga.ResourceInjector;
import org.axonframework.saga.SagaFactory;
import org.axonframework.saga.SagaRepository;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.annotation.AnnotatedSagaManager;
import org.axonframework.saga.repository.inmemory.InMemorySagaRepository;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.saga.ContinuedGivenState;
import org.axonframework.test.saga.FixtureConfiguration;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.FixtureExecutionResultImpl;
import org.axonframework.test.saga.GivenAggregateEventPublisher;
import org.axonframework.test.saga.WhenAggregateEventPublisher;
import org.axonframework.test.utils.AutowiredResourceInjector;
import org.axonframework.test.utils.CallbackBehavior;
import org.axonframework.test.utils.RecordingCommandBus;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;

public class AnnotatedSagaTestFixture
implements FixtureConfiguration,
ContinuedGivenState {
    private final StubEventScheduler eventScheduler;
    private final AnnotatedSagaManager sagaManager;
    private final List<Object> registeredResources = new LinkedList<Object>();
    private Map<Object, AggregateEventPublisherImpl> aggregatePublishers = new HashMap<Object, AggregateEventPublisherImpl>();
    private FixtureExecutionResultImpl fixtureExecutionResult;
    private final RecordingCommandBus commandBus;

    public AnnotatedSagaTestFixture(Class<? extends AbstractAnnotatedSaga> sagaType) {
        this.eventScheduler = new StubEventScheduler();
        GenericSagaFactory genericSagaFactory = new GenericSagaFactory();
        genericSagaFactory.setResourceInjector((ResourceInjector)new AutowiredResourceInjector(this.registeredResources));
        SimpleEventBus eventBus = new SimpleEventBus();
        InMemorySagaRepository sagaRepository = new InMemorySagaRepository();
        this.sagaManager = new AnnotatedSagaManager((SagaRepository)sagaRepository, (SagaFactory)genericSagaFactory, (EventBus)eventBus, new Class[]{sagaType});
        this.sagaManager.setSuppressExceptions(false);
        this.registeredResources.add(eventBus);
        this.commandBus = new RecordingCommandBus();
        this.registeredResources.add(this.commandBus);
        this.registeredResources.add(this.eventScheduler);
        this.fixtureExecutionResult = new FixtureExecutionResultImpl(sagaRepository, this.eventScheduler, (EventBus)eventBus, this.commandBus, sagaType);
    }

    @Override
    public FixtureExecutionResult whenTimeElapses(Duration elapsedTime) {
        this.fixtureExecutionResult.startRecording();
        for (EventMessage event : this.eventScheduler.advanceTime(elapsedTime)) {
            this.sagaManager.handle(event);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public FixtureExecutionResult whenTimeAdvancesTo(DateTime newDateTime) {
        this.fixtureExecutionResult.startRecording();
        for (EventMessage event : this.eventScheduler.advanceTime(newDateTime)) {
            this.sagaManager.handle(event);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public void registerResource(Object resource) {
        this.registeredResources.add(resource);
    }

    @Override
    public void setCallbackBehavior(CallbackBehavior callbackBehavior) {
        this.commandBus.setCallbackBehavior(callbackBehavior);
    }

    @Override
    public GivenAggregateEventPublisher givenAggregate(Object aggregateIdentifier) {
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState givenAPublished(Object event) {
        this.sagaManager.handle((EventMessage)new GenericEventMessage(event));
        return this;
    }

    @Override
    public GivenAggregateEventPublisher andThenAggregate(Object aggregateIdentifier) {
        return this.givenAggregate(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState andThenTimeElapses(Duration elapsedTime) {
        for (EventMessage event : this.eventScheduler.advanceTime(elapsedTime)) {
            this.sagaManager.handle(event);
        }
        return this;
    }

    @Override
    public ContinuedGivenState andThenTimeAdvancesTo(DateTime newDateTime) {
        for (EventMessage event : this.eventScheduler.advanceTime(newDateTime)) {
            this.sagaManager.handle(event);
        }
        return this;
    }

    @Override
    public ContinuedGivenState andThenAPublished(Object event) {
        this.sagaManager.handle((EventMessage)new GenericEventMessage(event));
        return this;
    }

    @Override
    public WhenAggregateEventPublisher whenAggregate(Object aggregateIdentifier) {
        this.fixtureExecutionResult.startRecording();
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public FixtureExecutionResult whenPublishingA(Object event) {
        this.fixtureExecutionResult.startRecording();
        this.sagaManager.handle((EventMessage)new GenericEventMessage(event));
        return this.fixtureExecutionResult;
    }

    @Override
    public DateTime currentTime() {
        return this.eventScheduler.getCurrentDateTime();
    }

    @Override
    public <T> T registerCommandGateway(Class<T> gatewayInterface) {
        return this.registerCommandGateway(gatewayInterface, null);
    }

    @Override
    public <T> T registerCommandGateway(Class<T> gatewayInterface, T stubImplementation) {
        StubAwareGatewayProxyFactory factory = new StubAwareGatewayProxyFactory(stubImplementation, this.commandBus);
        Object gateway = factory.createGateway(gatewayInterface);
        this.registerResource(gateway);
        return (T)gateway;
    }

    private AggregateEventPublisherImpl getPublisherFor(Object aggregateIdentifier) {
        if (!this.aggregatePublishers.containsKey(aggregateIdentifier)) {
            this.aggregatePublishers.put(aggregateIdentifier, new AggregateEventPublisherImpl());
        }
        return this.aggregatePublishers.get(aggregateIdentifier);
    }

    private static class ReturnResultFromStub<R>
    implements GatewayProxyFactory.InvocationHandler<R> {
        private final GatewayProxyFactory.InvocationHandler<Future<R>> dispatcher;
        private final Object stubGateway;

        public ReturnResultFromStub(GatewayProxyFactory.InvocationHandler<Future<R>> dispatcher, Object stubGateway) {
            this.dispatcher = dispatcher;
            this.stubGateway = stubGateway;
        }

        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Throwable {
            Future future = (Future)this.dispatcher.invoke(proxy, invokedMethod, args);
            if (this.stubGateway != null) {
                return (R)invokedMethod.invoke(this.stubGateway, args);
            }
            if (future.isDone()) {
                return (R)future.get();
            }
            return null;
        }
    }

    private static class StubAwareGatewayProxyFactory
    extends GatewayProxyFactory {
        private final Object stubImplementation;

        public StubAwareGatewayProxyFactory(Object stubImplementation, RecordingCommandBus commandBus) {
            super((CommandBus)commandBus, new CommandDispatchInterceptor[0]);
            this.stubImplementation = stubImplementation;
        }

        protected <R> GatewayProxyFactory.InvocationHandler<R> wrapToWaitForResult(GatewayProxyFactory.InvocationHandler<Future<R>> delegate) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }

        protected <R> GatewayProxyFactory.InvocationHandler<R> wrapToReturnWithFixedTimeout(GatewayProxyFactory.InvocationHandler<Future<R>> delegate, long timeout, TimeUnit timeUnit) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }

        protected <R> GatewayProxyFactory.InvocationHandler<R> wrapToReturnWithTimeoutInArguments(GatewayProxyFactory.InvocationHandler<Future<R>> delegate, int timeoutIndex, int timeUnitIndex) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }
    }

    private class AggregateEventPublisherImpl
    implements GivenAggregateEventPublisher,
    WhenAggregateEventPublisher {
        @Override
        public ContinuedGivenState published(Object ... events) {
            this.publish(events);
            return AnnotatedSagaTestFixture.this;
        }

        @Override
        public FixtureExecutionResult publishes(Object event) {
            this.publish(event);
            return AnnotatedSagaTestFixture.this.fixtureExecutionResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void publish(Object ... events) {
            DateTimeUtils.setCurrentMillisFixed((long)AnnotatedSagaTestFixture.this.currentTime().getMillis());
            try {
                for (Object event : events) {
                    AnnotatedSagaTestFixture.this.sagaManager.handle((EventMessage)new GenericEventMessage(event));
                }
            }
            finally {
                DateTimeUtils.setCurrentMillisSystem();
            }
        }
    }
}

