/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.Message;
import org.axonframework.test.FixtureExecutionException;

public class FixtureResourceParameterResolverFactory
extends ParameterResolverFactory {
    private final List<Object> injectableResources;
    private boolean enabled = true;

    private FixtureResourceParameterResolverFactory(List<Object> injectableResources) {
        this.injectableResources = new ArrayList<Object>(injectableResources);
    }

    public static FixtureResourceParameterResolverFactory register(List<Object> injectableResources) {
        FixtureResourceParameterResolverFactory factory = new FixtureResourceParameterResolverFactory(injectableResources);
        ParameterResolverFactory.registerFactory((ParameterResolverFactory)factory);
        return factory;
    }

    public boolean supportsPayloadResolution() {
        return false;
    }

    protected ParameterResolver createInstance(Annotation[] memberAnnotations, Class<?> parameterType, Annotation[] parameterAnnotations) {
        if (!this.enabled) {
            return null;
        }
        return new LazyParameterResolver(parameterType, this.injectableResources);
    }

    public void disable() {
        this.enabled = false;
    }

    private class LazyParameterResolver
    implements ParameterResolver {
        private final Class<?> parameterType;
        private final List<Object> injectableResources;

        public LazyParameterResolver(Class<?> parameterType, List<Object> injectableResources) {
            this.parameterType = parameterType;
            this.injectableResources = injectableResources;
        }

        public Object resolveParameterValue(Message message) {
            for (Object resource : this.injectableResources) {
                if (!this.parameterType.isInstance(resource)) continue;
                return resource;
            }
            throw new FixtureExecutionException("No resource of type [" + this.parameterType.getName() + "] has been registered. It is required for one of the handlers being executed.");
        }

        public boolean matches(Message message) {
            return true;
        }
    }
}

