/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.EventMessage;
import org.axonframework.test.Reporter;
import org.axonframework.test.ResultValidator;
import org.axonframework.test.matchers.EqualFieldsMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class ResultValidatorImpl
implements ResultValidator,
CommandCallback<Object> {
    private final Collection<DomainEventMessage> storedEvents;
    private final Collection<EventMessage> publishedEvents;
    private Object actualReturnValue;
    private Throwable actualException;
    private final Reporter reporter = new Reporter();

    public ResultValidatorImpl(Collection<DomainEventMessage> storedEvents, Collection<EventMessage> publishedEvents) {
        this.storedEvents = storedEvents;
        this.publishedEvents = publishedEvents;
    }

    @Override
    public ResultValidator expectEvents(Object ... expectedEvents) {
        if (this.publishedEvents.size() != this.storedEvents.size()) {
            this.reporter.reportDifferenceInStoredVsPublished(this.storedEvents, this.publishedEvents, this.actualException);
        }
        return this.expectPublishedEvents(expectedEvents);
    }

    @Override
    public ResultValidator expectEventsMatching(Matcher<List<?>> matcher) {
        if (this.publishedEvents.size() != this.storedEvents.size()) {
            this.reporter.reportDifferenceInStoredVsPublished(this.storedEvents, this.publishedEvents, this.actualException);
        }
        return this.expectPublishedEventsMatching(matcher);
    }

    @Override
    public ResultValidator expectPublishedEvents(Object ... expectedEvents) {
        if (expectedEvents.length != this.publishedEvents.size()) {
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<EventMessage> iterator = this.publishedEvents.iterator();
        for (Object expectedEvent : expectedEvents) {
            EventMessage actualEvent = iterator.next();
            if (this.verifyEventEquality(expectedEvent, actualEvent.getPayload())) continue;
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator expectPublishedEventsMatching(Matcher<List<?>> matcher) {
        if (!matcher.matches(this.publishedEvents)) {
            this.reporter.reportWrongEvent(this.publishedEvents, this.descriptionOf(matcher), this.actualException);
        }
        return this;
    }

    private StringDescription descriptionOf(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        return description;
    }

    @Override
    public ResultValidator expectStoredEvents(Object ... expectedEvents) {
        if (expectedEvents.length != this.storedEvents.size()) {
            this.reporter.reportWrongEvent(this.storedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<DomainEventMessage> iterator = this.storedEvents.iterator();
        for (Object expectedEvent : expectedEvents) {
            DomainEventMessage actualEvent = iterator.next();
            if (this.verifyEventEquality(expectedEvent, actualEvent)) continue;
            this.reporter.reportWrongEvent(this.storedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator expectStoredEventsMatching(Matcher<List<?>> matcher) {
        if (!matcher.matches(this.storedEvents)) {
            this.reporter.reportWrongEvent(this.storedEvents, this.descriptionOf(matcher), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator expectVoidReturnType() {
        return this.expectReturnValue(CoreMatchers.nullValue());
    }

    @Override
    public ResultValidator expectReturnValue(Object expectedReturnValue) {
        if (expectedReturnValue == null) {
            return this.expectReturnValue(CoreMatchers.nullValue());
        }
        return this.expectReturnValue(CoreMatchers.equalTo((Object)expectedReturnValue));
    }

    @Override
    public ResultValidator expectReturnValue(Matcher<?> matcher) {
        if (matcher == null) {
            return this.expectReturnValue(CoreMatchers.nullValue());
        }
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)description);
        } else if (!matcher.matches(this.actualReturnValue)) {
            this.reporter.reportWrongResult(this.actualReturnValue, (Description)description);
        }
        return this;
    }

    @Override
    public ResultValidator expectException(Class<? extends Throwable> expectedException) {
        return this.expectException(CoreMatchers.instanceOf(expectedException));
    }

    @Override
    public ResultValidator expectException(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        if (this.actualException == null) {
            this.reporter.reportUnexpectedReturnValue(this.actualReturnValue, (Description)description);
        }
        if (!matcher.matches((Object)this.actualException)) {
            this.reporter.reportWrongException(this.actualException, (Description)description);
        }
        return this;
    }

    public void onSuccess(Object result) {
        this.actualReturnValue = result;
    }

    public void onFailure(Throwable cause) {
        this.actualException = cause;
    }

    private boolean verifyEventEquality(Object expectedEvent, Object actualEvent) {
        if (!expectedEvent.getClass().equals(actualEvent.getClass())) {
            return false;
        }
        EqualFieldsMatcher<Object> matcher = new EqualFieldsMatcher<Object>(expectedEvent);
        if (!matcher.matches(actualEvent)) {
            this.reporter.reportDifferentEventContents(expectedEvent.getClass(), matcher.getFailedField(), matcher.getFailedFieldActualValue(), matcher.getFailedFieldExpectedValue());
        }
        return true;
    }
}

