/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.saga.GenericSagaFactory;
import org.axonframework.saga.ResourceInjector;
import org.axonframework.saga.SagaFactory;
import org.axonframework.saga.SagaRepository;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.annotation.AnnotatedSagaManager;
import org.axonframework.saga.repository.inmemory.InMemorySagaRepository;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.saga.ContinuedGivenState;
import org.axonframework.test.saga.FixtureConfiguration;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.FixtureExecutionResultImpl;
import org.axonframework.test.saga.GivenAggregateEventPublisher;
import org.axonframework.test.saga.WhenAggregateEventPublisher;
import org.axonframework.test.utils.AutowiredResourceInjector;
import org.axonframework.test.utils.RecordingCommandBus;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;

public class AnnotatedSagaTestFixture
implements FixtureConfiguration,
ContinuedGivenState {
    private final StubEventScheduler eventScheduler;
    private final AnnotatedSagaManager sagaManager;
    private final List<Object> registeredResources = new LinkedList<Object>();
    private Map<Object, AggregateEventPublisherImpl> aggregatePublishers = new HashMap<Object, AggregateEventPublisherImpl>();
    private FixtureExecutionResultImpl fixtureExecutionResult;

    public AnnotatedSagaTestFixture(Class<? extends AbstractAnnotatedSaga> sagaType) {
        this.eventScheduler = new StubEventScheduler();
        GenericSagaFactory genericSagaFactory = new GenericSagaFactory();
        genericSagaFactory.setResourceInjector((ResourceInjector)new AutowiredResourceInjector(this.registeredResources));
        SimpleEventBus eventBus = new SimpleEventBus(false);
        InMemorySagaRepository sagaRepository = new InMemorySagaRepository();
        this.sagaManager = new AnnotatedSagaManager((SagaRepository)sagaRepository, (SagaFactory)genericSagaFactory, (EventBus)eventBus, new Class[]{sagaType});
        this.sagaManager.setSuppressExceptions(false);
        this.registeredResources.add(eventBus);
        RecordingCommandBus commandBus = new RecordingCommandBus();
        this.registeredResources.add(commandBus);
        this.registeredResources.add(this.eventScheduler);
        this.fixtureExecutionResult = new FixtureExecutionResultImpl(sagaRepository, this.eventScheduler, (EventBus)eventBus, commandBus, sagaType);
    }

    @Override
    public FixtureExecutionResult whenTimeElapses(Duration elapsedTime) {
        this.fixtureExecutionResult.startRecording();
        for (EventMessage event : this.eventScheduler.advanceTime(elapsedTime)) {
            this.sagaManager.handle(event);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public FixtureExecutionResult whenTimeAdvancesTo(DateTime newDateTime) {
        this.fixtureExecutionResult.startRecording();
        for (EventMessage event : this.eventScheduler.advanceTime(newDateTime)) {
            this.sagaManager.handle(event);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public void registerResource(Object resource) {
        this.registeredResources.add(resource);
    }

    @Override
    public GivenAggregateEventPublisher givenAggregate(Object aggregateIdentifier) {
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState givenAPublished(Object event) {
        this.sagaManager.handle((EventMessage)new GenericEventMessage(event));
        return this;
    }

    @Override
    public GivenAggregateEventPublisher andThenAggregate(Object aggregateIdentifier) {
        return this.givenAggregate(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState andThenAPublished(Object event) {
        this.sagaManager.handle((EventMessage)new GenericEventMessage(event));
        return this;
    }

    @Override
    public WhenAggregateEventPublisher whenAggregate(Object aggregateIdentifier) {
        this.fixtureExecutionResult.startRecording();
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public FixtureExecutionResult whenPublishingA(Object event) {
        this.fixtureExecutionResult.startRecording();
        this.sagaManager.handle((EventMessage)new GenericEventMessage(event));
        return this.fixtureExecutionResult;
    }

    @Override
    public DateTime currentTime() {
        return this.eventScheduler.getCurrentDateTime();
    }

    private AggregateEventPublisherImpl getPublisherFor(Object aggregateIdentifier) {
        if (!this.aggregatePublishers.containsKey(aggregateIdentifier)) {
            this.aggregatePublishers.put(aggregateIdentifier, new AggregateEventPublisherImpl());
        }
        return this.aggregatePublishers.get(aggregateIdentifier);
    }

    private class AggregateEventPublisherImpl
    implements GivenAggregateEventPublisher,
    WhenAggregateEventPublisher {
        @Override
        public ContinuedGivenState published(Object ... events) {
            this.publish(events);
            return AnnotatedSagaTestFixture.this;
        }

        @Override
        public FixtureExecutionResult publishes(Object event) {
            this.publish(event);
            return AnnotatedSagaTestFixture.this.fixtureExecutionResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void publish(Object ... events) {
            DateTimeUtils.setCurrentMillisFixed((long)AnnotatedSagaTestFixture.this.currentTime().getMillis());
            try {
                for (Object event : events) {
                    AnnotatedSagaTestFixture.this.sagaManager.handle((EventMessage)new GenericEventMessage(event));
                }
            }
            finally {
                DateTimeUtils.setCurrentMillisSystem();
            }
        }
    }
}

