/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.domain.Message;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class PayloadsMatcher<T extends Message>
extends BaseMatcher<List<? extends T>> {
    private final Matcher<? extends List> matcher;
    private final Class<? extends T> expectedMessageType;

    public PayloadsMatcher(Class<? extends T> expectedMessageType, Matcher<? extends List> matcher) {
        this.matcher = matcher;
        this.expectedMessageType = expectedMessageType;
    }

    public boolean matches(Object item) {
        if (!List.class.isInstance(item)) {
            return false;
        }
        ArrayList<Object> payloads = new ArrayList<Object>();
        for (Object listItem : (List)item) {
            if (Message.class.isInstance(listItem)) {
                if (!this.expectedMessageType.isInstance(listItem)) {
                    return false;
                }
                payloads.add(((Message)listItem).getPayload());
                continue;
            }
            payloads.add(item);
        }
        return this.matcher.matches(payloads);
    }

    public void describeTo(Description description) {
        description.appendText("List with EventMessages with Payloads matching <");
        this.matcher.describeTo(description);
        description.appendText(">");
    }
}

