/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.util.List;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.Message;
import org.axonframework.test.matchers.EmptyCollectionMatcher;
import org.axonframework.test.matchers.EqualFieldsMatcher;
import org.axonframework.test.matchers.ExactSequenceMatcher;
import org.axonframework.test.matchers.ListWithAllOfMatcher;
import org.axonframework.test.matchers.ListWithAnyOfMatcher;
import org.axonframework.test.matchers.NullOrVoidMatcher;
import org.axonframework.test.matchers.PayloadMatcher;
import org.axonframework.test.matchers.PayloadsMatcher;
import org.axonframework.test.matchers.SequenceMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public abstract class Matchers {
    private Matchers() {
    }

    public static Matcher<List<? extends EventMessage>> eventPayloadsMatching(Matcher<? extends List> matcher) {
        return new PayloadsMatcher<EventMessage>(EventMessage.class, matcher);
    }

    public static Matcher<List<? extends Message>> messagePayloadsMatching(Matcher<? extends List> matcher) {
        return new PayloadsMatcher<Message>(Message.class, matcher);
    }

    public static Matcher<? extends EventMessage> eventWithPayload(Matcher<?> payloadMatcher) {
        return new PayloadMatcher(payloadMatcher);
    }

    @Factory
    public static <T> ListWithAllOfMatcher listWithAllOf(Matcher<T> ... matchers) {
        return new ListWithAllOfMatcher<T>(matchers);
    }

    @Factory
    public static <T> ListWithAnyOfMatcher<T> listWithAnyOf(Matcher<T> ... matchers) {
        return new ListWithAnyOfMatcher<T>(matchers);
    }

    @Factory
    public static <T> SequenceMatcher<T> sequenceOf(Matcher<? extends T> ... matchers) {
        return new SequenceMatcher<T>(matchers);
    }

    @Factory
    public static <T> ExactSequenceMatcher<T> exactSequenceOf(Matcher<? extends T> ... matchers) {
        return new ExactSequenceMatcher<T>(matchers);
    }

    @Factory
    public static EmptyCollectionMatcher noEvents() {
        return new EmptyCollectionMatcher("events");
    }

    @Factory
    public static EmptyCollectionMatcher noCommands() {
        return new EmptyCollectionMatcher("commands");
    }

    @Factory
    public static <T> EqualFieldsMatcher<T> equalTo(T expected) {
        return new EqualFieldsMatcher<T>(expected);
    }

    @Factory
    public static NullOrVoidMatcher andNoMore() {
        return Matchers.nothing();
    }

    @Factory
    public static NullOrVoidMatcher nothing() {
        return new NullOrVoidMatcher();
    }
}

