/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.List;
import org.axonframework.domain.ApplicationEvent;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.eventscheduler.ScheduledItem;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

class EventSchedulerValidator {
    private final StubEventScheduler eventScheduler;

    public EventSchedulerValidator(StubEventScheduler eventScheduler) {
        this.eventScheduler = eventScheduler;
    }

    public void assertScheduledEvent(Duration duration, Matcher<? extends ApplicationEvent> matcher) {
        DateTime targetTime = this.eventScheduler.getCurrentDateTime().plus((ReadableDuration)duration);
        this.assertScheduledEvent(targetTime, matcher);
    }

    public void assertScheduledEvent(DateTime scheduledTime, Matcher<? extends ApplicationEvent> matcher) {
        List<ScheduledItem> schedule = this.eventScheduler.getScheduledItems();
        for (ScheduledItem item : schedule) {
            if (!item.getScheduleTime().equals((Object)scheduledTime) || !matcher.matches((Object)item.getEvent())) continue;
            return;
        }
        StringDescription expected = new StringDescription();
        StringDescription actual = new StringDescription();
        matcher.describeTo((Description)expected);
        this.describe(this.eventScheduler.getScheduledItems(), (Description)actual);
        throw new AxonAssertionError(String.format("Did not find an event at the given schedule. \nExpected:\n<%s> at <%s>\nGot:%s\n", expected, scheduledTime, actual));
    }

    private void describe(List<ScheduledItem> scheduledItems, Description description) {
        if (scheduledItems.isEmpty()) {
            description.appendText("\n<no scheduled events>");
        }
        for (ScheduledItem item : scheduledItems) {
            description.appendText("\n<").appendText(item.getEvent().toString()).appendText("> at <").appendText(item.getScheduleTime().toString()).appendText(">");
        }
    }

    public void assertNoScheduledEvents() {
        List<ScheduledItem> scheduledItems = this.eventScheduler.getScheduledItems();
        if (scheduledItems != null && !scheduledItems.isEmpty()) {
            throw new AxonAssertionError("Expected no scheduled events, got " + scheduledItems.size());
        }
    }
}

