/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.domain.AggregateIdentifier;
import org.axonframework.domain.ApplicationEvent;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.Event;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.saga.GenericSagaFactory;
import org.axonframework.saga.ResourceInjector;
import org.axonframework.saga.SagaFactory;
import org.axonframework.saga.SagaRepository;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.annotation.AnnotatedSagaManager;
import org.axonframework.saga.repository.inmemory.InMemorySagaRepository;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.saga.ContinuedGivenState;
import org.axonframework.test.saga.FixtureConfiguration;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.FixtureExecutionResultImpl;
import org.axonframework.test.saga.GivenAggregateEventPublisher;
import org.axonframework.test.saga.WhenAggregateEventPublisher;
import org.axonframework.test.utils.AutowiredResourceInjector;
import org.axonframework.test.utils.DomainEventUtils;
import org.axonframework.test.utils.RecordingCommandBus;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;

public class AnnotatedSagaTestFixture
implements FixtureConfiguration,
ContinuedGivenState {
    private final StubEventScheduler eventScheduler;
    private final AnnotatedSagaManager sagaManager;
    private final List<Object> registeredResources = new LinkedList<Object>();
    private Map<AggregateIdentifier, AggregateEventPublisherImpl> aggregatePublishers = new HashMap<AggregateIdentifier, AggregateEventPublisherImpl>();
    private FixtureExecutionResultImpl fixtureExecutionResult;

    public AnnotatedSagaTestFixture(Class<? extends AbstractAnnotatedSaga> sagaType) {
        this.eventScheduler = new StubEventScheduler();
        GenericSagaFactory genericSagaFactory = new GenericSagaFactory();
        genericSagaFactory.setResourceInjector((ResourceInjector)new AutowiredResourceInjector(this.registeredResources));
        SimpleEventBus eventBus = new SimpleEventBus(false);
        InMemorySagaRepository sagaRepository = new InMemorySagaRepository();
        this.sagaManager = new AnnotatedSagaManager((SagaRepository)sagaRepository, (SagaFactory)genericSagaFactory, (EventBus)eventBus, new Class[]{sagaType});
        this.sagaManager.setSuppressExceptions(false);
        this.registeredResources.add(eventBus);
        RecordingCommandBus commandBus = new RecordingCommandBus();
        this.registeredResources.add(commandBus);
        this.registeredResources.add(this.eventScheduler);
        this.fixtureExecutionResult = new FixtureExecutionResultImpl(sagaRepository, this.eventScheduler, (EventBus)eventBus, commandBus, sagaType);
    }

    @Override
    public FixtureExecutionResult whenTimeElapses(Duration elapsedTime) {
        this.fixtureExecutionResult.startRecording();
        for (Event event : this.eventScheduler.advanceTime(elapsedTime)) {
            this.sagaManager.handle(event);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public FixtureExecutionResult whenTimeAdvancesTo(DateTime newDateTime) {
        this.fixtureExecutionResult.startRecording();
        for (Event event : this.eventScheduler.advanceTime(newDateTime)) {
            this.sagaManager.handle(event);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public void registerResource(Object resource) {
        this.registeredResources.add(resource);
    }

    @Override
    public GivenAggregateEventPublisher givenAggregate(AggregateIdentifier aggregateIdentifier) {
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState givenAPublished(ApplicationEvent applicationEvent) {
        this.sagaManager.handle((Event)applicationEvent);
        return this;
    }

    @Override
    public GivenAggregateEventPublisher andThenAggregate(AggregateIdentifier aggregateIdentifier) {
        return this.givenAggregate(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState andThenAPublished(ApplicationEvent applicationEvent) {
        this.sagaManager.handle((Event)applicationEvent);
        return this;
    }

    @Override
    public WhenAggregateEventPublisher whenAggregate(AggregateIdentifier aggregateIdentifier) {
        this.fixtureExecutionResult.startRecording();
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public FixtureExecutionResult whenPublishingA(ApplicationEvent applicationEvent) {
        this.fixtureExecutionResult.startRecording();
        this.sagaManager.handle((Event)applicationEvent);
        return this.fixtureExecutionResult;
    }

    @Override
    public DateTime currentTime() {
        return this.eventScheduler.getCurrentDateTime();
    }

    private AggregateEventPublisherImpl getPublisherFor(AggregateIdentifier aggregateIdentifier) {
        if (!this.aggregatePublishers.containsKey(aggregateIdentifier)) {
            this.aggregatePublishers.put(aggregateIdentifier, new AggregateEventPublisherImpl(aggregateIdentifier));
        }
        return this.aggregatePublishers.get(aggregateIdentifier);
    }

    private class AggregateEventPublisherImpl
    implements GivenAggregateEventPublisher,
    WhenAggregateEventPublisher {
        private final AggregateIdentifier aggregateIdentifier;
        private final AtomicLong sequenceCounter;

        public AggregateEventPublisherImpl(AggregateIdentifier aggregateIdentifier) {
            this.aggregateIdentifier = aggregateIdentifier;
            this.sequenceCounter = new AtomicLong();
        }

        @Override
        public ContinuedGivenState published(DomainEvent ... events) {
            this.publish(events);
            return AnnotatedSagaTestFixture.this;
        }

        @Override
        public FixtureExecutionResult publishes(DomainEvent event) {
            this.publish(event);
            return AnnotatedSagaTestFixture.this.fixtureExecutionResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void publish(DomainEvent ... events) {
            DateTimeUtils.setCurrentMillisFixed((long)AnnotatedSagaTestFixture.this.currentTime().getMillis());
            try {
                for (DomainEvent event : events) {
                    DomainEventUtils.setAggregateIdentifier(event, this.aggregateIdentifier);
                    DomainEventUtils.setSequenceNumber(event, this.sequenceCounter.getAndIncrement());
                    AnnotatedSagaTestFixture.this.sagaManager.handle((Event)event);
                }
            }
            finally {
                DateTimeUtils.setCurrentMillisSystem();
            }
        }
    }
}

