/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandHandler;

public class RecordingCommandBus
implements CommandBus {
    private Map<Class<?>, CommandHandler<?>> subscriptions = new HashMap();
    private List<Object> dispatchedCommands = new ArrayList<Object>();

    public void dispatch(Object command) {
        this.dispatchedCommands.add(command);
    }

    public <R> void dispatch(Object command, CommandCallback<R> callback) {
        this.dispatchedCommands.add(command);
    }

    public <C> void subscribe(Class<C> commandType, CommandHandler<? super C> handler) {
        if (!this.subscriptions.containsKey(commandType)) {
            this.subscriptions.put(commandType, handler);
        }
    }

    public <C> void unsubscribe(Class<C> commandType, CommandHandler<? super C> handler) {
        this.subscriptions.remove(commandType);
    }

    public void clearCommands() {
        this.dispatchedCommands.clear();
    }

    public void clearSubscriptions() {
        this.subscriptions.clear();
    }

    public boolean isSubscribed(CommandHandler<?> commandHandler) {
        return this.subscriptions.containsValue(commandHandler);
    }

    public <C> boolean isSubscribed(Class<C> commandType, CommandHandler<? super C> commandHandler) {
        return this.subscriptions.containsKey(commandType) && this.subscriptions.get(commandType).equals(commandHandler);
    }

    public Map<Class<?>, CommandHandler<?>> getSubscriptions() {
        return this.subscriptions;
    }

    public List<Object> getDispatchedCommands() {
        return this.dispatchedCommands;
    }
}

