/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.List;
import org.axonframework.domain.ApplicationEvent;
import org.axonframework.domain.Event;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.repository.inmemory.InMemorySagaRepository;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.matchers.Matchers;
import org.axonframework.test.saga.CommandValidator;
import org.axonframework.test.saga.EventSchedulerValidator;
import org.axonframework.test.saga.EventValidator;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.RepositoryContentValidator;
import org.axonframework.test.utils.RecordingCommandBus;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.joda.time.Duration;

class FixtureExecutionResultImpl
implements FixtureExecutionResult {
    private final RepositoryContentValidator repositoryContentValidator;
    private final EventValidator eventValidator;
    private final EventSchedulerValidator eventSchedulerValidator;
    private CommandValidator commandValidator;

    FixtureExecutionResultImpl(InMemorySagaRepository sagaRepository, StubEventScheduler eventScheduler, EventBus eventBus, RecordingCommandBus commandBus, Class<? extends AbstractAnnotatedSaga> sagaType) {
        this.commandValidator = new CommandValidator(commandBus);
        this.repositoryContentValidator = new RepositoryContentValidator(sagaRepository, sagaType);
        this.eventValidator = new EventValidator(eventBus);
        this.eventSchedulerValidator = new EventSchedulerValidator(eventScheduler);
    }

    public void startRecording() {
        this.eventValidator.startRecording();
        this.commandValidator.startRecording();
    }

    @Override
    public FixtureExecutionResult expectActiveSagas(int expected) {
        this.repositoryContentValidator.assertActiveSagas(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectAssociationWith(String associationKey, Object associationValue) {
        this.repositoryContentValidator.assertAssociationPresent(associationKey, associationValue);
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoAssociationWith(String associationKey, Object associationValue) {
        this.repositoryContentValidator.assertNoAssociationPresent(associationKey, associationValue);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(Duration duration, Matcher<? extends ApplicationEvent> matcher) {
        this.eventSchedulerValidator.assertScheduledEvent(duration, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(Duration duration, ApplicationEvent applicationEvent) {
        return this.expectScheduledEvent(duration, (Matcher<? extends ApplicationEvent>)Matchers.equalTo(applicationEvent));
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(Duration duration, Class<? extends ApplicationEvent> eventType) {
        return this.expectScheduledEvent(duration, (Matcher<? extends ApplicationEvent>)CoreMatchers.any(eventType));
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(DateTime scheduledTime, Matcher<? extends ApplicationEvent> matcher) {
        this.eventSchedulerValidator.assertScheduledEvent(scheduledTime, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(DateTime scheduledTime, ApplicationEvent applicationEvent) {
        return this.expectScheduledEvent(scheduledTime, (Matcher<? extends ApplicationEvent>)Matchers.equalTo(applicationEvent));
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(DateTime scheduledTime, Class<? extends ApplicationEvent> eventType) {
        return this.expectScheduledEvent(scheduledTime, (Matcher<? extends ApplicationEvent>)CoreMatchers.any(eventType));
    }

    @Override
    public FixtureExecutionResult expectDispatchedCommandsEqualTo(Object ... expected) {
        this.commandValidator.assertDispatchedEqualTo(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectDispatchedCommandsMatching(Matcher<List<?>> matcher) {
        this.commandValidator.assertDispatchedMatching(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEvents() {
        this.eventSchedulerValidator.assertNoScheduledEvents();
        return this;
    }

    @Override
    public FixtureExecutionResult expectPublishedEvents(Matcher<List<? extends Event>> matcher) {
        this.eventValidator.assertPublishedEvents(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectPublishedEvents(Event ... expected) {
        this.eventValidator.assertPublishedEvents(expected);
        return this;
    }
}

