/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.axonframework.domain.ApplicationEvent;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.Event;
import org.axonframework.domain.EventBase;
import org.axonframework.domain.SystemEvent;
import org.axonframework.test.matchers.MatcherExecutionException;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class EqualEventMatcher<T extends Event>
extends BaseMatcher<T> {
    private final T expected;
    private Field failedField;
    private Object failedFieldExpectedValue;
    private Object failedFieldActualValue;

    public EqualEventMatcher(T expected) {
        this.expected = expected;
    }

    public boolean matches(Object item) {
        return this.expected.getClass().isInstance(item) && this.matchesSafely((Event)item);
    }

    private boolean matchesSafely(Event actualEvent) {
        return this.expected.getClass().equals(actualEvent.getClass()) && this.fieldsMatch(this.expected.getClass(), (Event)this.expected, actualEvent);
    }

    private boolean fieldsMatch(Class<?> aClass, Event expectedEvent, Event actualEvent) {
        boolean match = true;
        for (Field field : aClass.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object expectedFieldValue = field.get(expectedEvent);
                Object actualFieldValue = field.get(actualEvent);
                if (expectedFieldValue != null && actualFieldValue != null && expectedFieldValue.getClass().isArray()) {
                    if (Arrays.deepEquals(new Object[]{expectedFieldValue}, new Object[]{actualFieldValue})) continue;
                    this.failedField = field;
                    this.failedFieldExpectedValue = expectedFieldValue;
                    this.failedFieldActualValue = actualFieldValue;
                    return false;
                }
                if ((expectedFieldValue == null || expectedFieldValue.equals(actualFieldValue)) && (expectedFieldValue != null || actualFieldValue == null)) continue;
                this.failedField = field;
                this.failedFieldExpectedValue = expectedFieldValue;
                this.failedFieldActualValue = actualFieldValue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new MatcherExecutionException("Could not confirm event equality due to an exception", e);
            }
        }
        if (aClass.getSuperclass() != DomainEvent.class && aClass.getSuperclass() != ApplicationEvent.class && aClass.getSuperclass() != SystemEvent.class && aClass.getSuperclass() != Event.class && aClass.getSuperclass() != EventBase.class && aClass.getSuperclass() != Object.class) {
            match = this.fieldsMatch(aClass.getSuperclass(), expectedEvent, actualEvent);
        }
        return match;
    }

    public Field getFailedField() {
        return this.failedField;
    }

    public Object getFailedFieldExpectedValue() {
        return this.failedFieldExpectedValue;
    }

    public Object getFailedFieldActualValue() {
        return this.failedFieldActualValue;
    }

    public void describeTo(Description description) {
        description.appendText(this.expected.getClass().getName());
        if (this.failedField != null) {
            description.appendText(" (failed on field '").appendText(this.failedField.getName()).appendText("')");
        }
    }
}

