/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotation.AnnotationCommandHandlerAdapter;
import org.axonframework.domain.AggregateIdentifier;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.Event;
import org.axonframework.domain.SimpleDomainEventStream;
import org.axonframework.domain.UUIDAggregateIdentifier;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.GenericEventSourcingRepository;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.EventStoreException;
import org.axonframework.monitoring.jmx.JmxConfiguration;
import org.axonframework.test.FixtureConfiguration;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.ResultValidator;
import org.axonframework.test.ResultValidatorImpl;
import org.axonframework.test.TestExecutor;

class GivenWhenThenTestFixture
implements FixtureConfiguration,
TestExecutor {
    private EventSourcingRepository<?> repository;
    private SimpleCommandBus commandBus;
    private EventBus eventBus;
    private AggregateIdentifier aggregateIdentifier;
    private EventStore eventStore;
    private List<DomainEvent> givenEvents;
    private List<DomainEvent> storedEvents;
    private List<Event> publishedEvents;
    private long sequenceNumber = 0L;

    GivenWhenThenTestFixture() {
        JmxConfiguration.getInstance().disableMonitoring();
        this.aggregateIdentifier = new UUIDAggregateIdentifier();
        this.eventBus = new RecordingEventBus();
        this.commandBus = new SimpleCommandBus();
        this.eventStore = new RecordingEventStore();
        this.clearGivenWhenState();
    }

    @Override
    public <T extends EventSourcedAggregateRoot> EventSourcingRepository<T> createGenericRepository(Class<T> aggregateClass) {
        this.registerRepository((EventSourcingRepository<?>)new GenericEventSourcingRepository(aggregateClass));
        return this.repository;
    }

    @Override
    public FixtureConfiguration registerRepository(EventSourcingRepository<?> eventSourcingRepository) {
        this.repository = eventSourcingRepository;
        eventSourcingRepository.setEventBus(this.eventBus);
        eventSourcingRepository.setEventStore(this.eventStore);
        return this;
    }

    @Override
    public FixtureConfiguration registerAnnotatedCommandHandler(Object annotatedCommandHandler) {
        AnnotationCommandHandlerAdapter commandHandlerAdapter = new AnnotationCommandHandlerAdapter(annotatedCommandHandler, (CommandBus)this.commandBus);
        commandHandlerAdapter.subscribe();
        return this;
    }

    @Override
    public FixtureConfiguration registerCommandHandler(Class<?> commandType, CommandHandler commandHandler) {
        this.commandBus.subscribe(commandType, commandHandler);
        return this;
    }

    @Override
    public TestExecutor given(DomainEvent ... domainEvents) {
        return this.given(Arrays.asList(domainEvents));
    }

    @Override
    public TestExecutor given(List<DomainEvent> domainEvents) {
        this.clearGivenWhenState();
        for (DomainEvent event : domainEvents) {
            this.setByReflection(DomainEvent.class, "aggregateIdentifier", event, (Serializable)this.aggregateIdentifier);
            this.setByReflection(DomainEvent.class, "sequenceNumber", event, Long.valueOf(this.sequenceNumber++));
        }
        this.givenEvents.addAll(domainEvents);
        return this;
    }

    @Override
    public ResultValidator when(Object command) {
        ResultValidatorImpl resultValidator = new ResultValidatorImpl(this.storedEvents, this.publishedEvents);
        this.commandBus.dispatch(command, (CommandCallback)resultValidator);
        return resultValidator;
    }

    private void clearGivenWhenState() {
        this.storedEvents = new ArrayList<DomainEvent>();
        this.publishedEvents = new ArrayList<Event>();
        this.givenEvents = new ArrayList<DomainEvent>();
        this.sequenceNumber = 0L;
    }

    @Override
    public AggregateIdentifier getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    @Override
    public void setAggregateIdentifier(AggregateIdentifier aggregateIdentifier) {
        this.aggregateIdentifier = aggregateIdentifier;
    }

    @Override
    public CommandBus getCommandBus() {
        return this.commandBus;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public EventStore getEventStore() {
        return this.eventStore;
    }

    @Override
    public EventSourcingRepository<?> getRepository() {
        return this.repository;
    }

    private void setByReflection(Class<?> eventClass, String fieldName, DomainEvent event, Serializable value) {
        try {
            Field field = eventClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(event, value);
        }
        catch (Exception e) {
            throw new FixtureExecutionException("This test fixture needs to be able to set fields by reflection", e);
        }
    }

    private class RecordingEventBus
    implements EventBus {
        private RecordingEventBus() {
        }

        public void publish(Event event) {
            GivenWhenThenTestFixture.this.publishedEvents.add(event);
        }

        public void subscribe(EventListener eventListener) {
        }

        public void unsubscribe(EventListener eventListener) {
        }
    }

    private class RecordingEventStore
    implements EventStore {
        private RecordingEventStore() {
        }

        public void appendEvents(String type, DomainEventStream events) {
            while (events.hasNext()) {
                DomainEvent next = events.next();
                GivenWhenThenTestFixture.this.storedEvents.add(next);
            }
        }

        public DomainEventStream readEvents(String type, AggregateIdentifier identifier) {
            if (!GivenWhenThenTestFixture.this.aggregateIdentifier.equals(identifier)) {
                throw new EventStoreException("You probably want to use aggregateIdentifier() on your fixture to get the aggregate identifier to use");
            }
            return new SimpleDomainEventStream(GivenWhenThenTestFixture.this.givenEvents);
        }
    }
}

