/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.Event;
import org.axonframework.test.AxonAssertionError;

class Reporter {
    private static final String NEWLINE = System.getProperty("line.separator");

    Reporter() {
    }

    public void reportDifferenceInStoredVsPublished(List<DomainEvent> storedEvents, List<Event> publishedEvents) {
        StringBuilder sb = new StringBuilder("The stored events do not match the published events.");
        this.appendEventOverview(sb, storedEvents, publishedEvents, "Stored events", "Published events");
        throw new AxonAssertionError(sb.toString());
    }

    public void reportWrongEvent(List<? extends Event> actualEvents, List<? extends Event> expectedEvents, Throwable probableCause) {
        StringBuilder sb = new StringBuilder("The published events do not match the expected events");
        this.appendEventOverview(sb, expectedEvents, actualEvents, "Expected", "Actual");
        if (probableCause != null) {
            sb.append(NEWLINE);
            sb.append("A probable cause for the wrong chain of events is an exception that occurred while handling the command");
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            probableCause.printStackTrace(new PrintWriter(charArrayWriter));
            sb.append(charArrayWriter.toCharArray());
        }
        throw new AxonAssertionError(sb.toString());
    }

    public void reportUnexpectedException(Throwable actualException, Object expectedReturnValue) {
        StringBuilder sb = new StringBuilder("The command handler threw an unexpected exception");
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        sb.append("Expected <");
        if (expectedReturnValue == null) {
            sb.append("null return value");
        } else if (expectedReturnValue == Void.TYPE) {
            sb.append("void return value");
        } else {
            sb.append("return value of type [");
            sb.append(expectedReturnValue.getClass().getSimpleName());
            sb.append("]");
        }
        sb.append("> but got <exception of type [").append(actualException.getClass().getSimpleName());
        sb.append("]>. Stack trace follows:");
        sb.append(NEWLINE);
        this.writeStackTrace(actualException, sb);
        sb.append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportWrongResult(Object actualReturnValue, Object expectedReturnValue) {
        StringBuilder sb = new StringBuilder("The command handler returned an unexpected value");
        sb.append(NEWLINE).append(NEWLINE).append("Expected <");
        this.describe(expectedReturnValue, sb);
        sb.append("> but got <");
        this.describe(actualReturnValue, sb);
        sb.append(">").append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportUnexpectedReturnValue(Object actualReturnValue, Class<? extends Throwable> expectedException) {
        StringBuilder sb = new StringBuilder("The command handler returned normally, but an exception was expected");
        sb.append(NEWLINE).append(NEWLINE).append("Expected <");
        sb.append("exception of type [").append(expectedException.getSimpleName());
        sb.append("]> but returned with <");
        this.describe(actualReturnValue, sb);
        sb.append(">").append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportWrongException(Throwable actualException, Class<? extends Throwable> expectedException) {
        StringBuilder sb = new StringBuilder("The command handler threw an exception, but not of the expected type");
        sb.append(NEWLINE).append(NEWLINE).append("Expected <").append("exception of type [").append(expectedException.getSimpleName()).append("]> but got <exception of type [").append(actualException.getClass().getSimpleName()).append("]>. Stacktrace follows: ").append(NEWLINE);
        this.writeStackTrace(actualException, sb);
        sb.append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    public void reportDifferentEventContents(Class<? extends Event> eventType, Field field, Object actual, Object expected) {
        StringBuilder sb = new StringBuilder("One of the events contained different values than expected");
        sb.append(NEWLINE).append(NEWLINE).append("In an event of type [").append(eventType.getSimpleName()).append("], the property [").append(field.getName()).append("] ");
        if (!eventType.equals(field.getDeclaringClass())) {
            sb.append("(declared in [").append(field.getDeclaringClass().getSimpleName()).append("]) ");
        }
        sb.append("was not as expected.").append(NEWLINE).append("Expected <").append(this.nullSafeToString(expected)).append("> but got <").append(this.nullSafeToString(actual)).append(">").append(NEWLINE);
        throw new AxonAssertionError(sb.toString());
    }

    private void writeStackTrace(Throwable actualException, StringBuilder sb) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        actualException.printStackTrace(pw);
        pw.flush();
        sb.append(new String(baos.toByteArray()));
    }

    private String nullSafeToString(Object value) {
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    private void describe(Object value, StringBuilder sb) {
        if (value == null) {
            sb.append("null return value");
        } else if (value == Void.TYPE) {
            sb.append("void return type");
        } else {
            sb.append(value.toString());
        }
    }

    private void appendEventOverview(StringBuilder sb, List<? extends Event> leftColumnEvents, List<? extends Event> rightColumnEvents, String leftColumnName, String rightColumnName) {
        ArrayList<String> actualTypes = new ArrayList<String>(rightColumnEvents.size());
        ArrayList<String> expectedTypes = new ArrayList<String>(leftColumnEvents.size());
        int largestExpectedSize = leftColumnName.length();
        for (Event event : rightColumnEvents) {
            actualTypes.add(event.getClass().getName());
        }
        for (Event event : leftColumnEvents) {
            String simpleName = event.getClass().getName();
            if (simpleName.length() > largestExpectedSize) {
                largestExpectedSize = simpleName.length();
            }
            expectedTypes.add(simpleName);
        }
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        sb.append(leftColumnName);
        this.pad(sb, leftColumnName.length(), largestExpectedSize, " ");
        sb.append("  |  ").append(rightColumnName).append(NEWLINE);
        this.pad(sb, 0, largestExpectedSize, "-");
        sb.append("--|--");
        this.pad(sb, 0, largestExpectedSize, "-");
        sb.append(NEWLINE);
        Iterator actualIterator = actualTypes.iterator();
        Iterator iterator = expectedTypes.iterator();
        while (actualIterator.hasNext() || iterator.hasNext()) {
            boolean difference;
            String expected = "";
            if (iterator.hasNext()) {
                expected = (String)iterator.next();
                sb.append(expected);
                this.pad(sb, expected.length(), largestExpectedSize, " ");
                difference = !actualIterator.hasNext();
            } else {
                this.pad(sb, 0, largestExpectedSize, " ");
                difference = true;
            }
            if (actualIterator.hasNext()) {
                String actual = (String)actualIterator.next();
                boolean bl = difference = difference || !actual.equals(expected);
                if (difference) {
                    sb.append(" <|> ");
                } else {
                    sb.append("  |  ");
                }
                sb.append(actual);
            } else {
                sb.append(" <|> ");
            }
            sb.append(NEWLINE);
        }
    }

    private void pad(StringBuilder sb, int currentLength, int targetLength, String character) {
        for (int t = currentLength; t < targetLength; ++t) {
            sb.append(character);
        }
    }
}

