/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandContext;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotation.AnnotationCommandHandlerAdapter;
import org.axonframework.commandhandling.interceptors.SimpleUnitOfWorkInterceptor;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.Event;
import org.axonframework.domain.EventBase;
import org.axonframework.domain.SimpleDomainEventStream;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.GenericEventSourcingRepository;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.EventStoreException;
import org.axonframework.monitoring.jmx.JmxConfiguration;
import org.axonframework.test.FixtureConfiguration;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.Reporter;
import org.axonframework.test.ResultValidator;
import org.axonframework.test.TestExecutor;

class GivenWhenThenTestFixture
implements ResultValidator,
FixtureConfiguration,
TestExecutor {
    private EventSourcingRepository<?> repository;
    private SimpleCommandBus commandBus;
    private EventBus eventBus;
    private UUID aggregateIdentifier;
    private EventStore eventStore;
    private List<DomainEvent> givenEvents;
    private List<DomainEvent> storedEvents;
    private List<Event> publishedEvents;
    private Object actualReturnValue;
    private Throwable actualException;
    private long sequenceNumber = 0L;
    private final Reporter reporter = new Reporter();

    GivenWhenThenTestFixture() {
        JmxConfiguration.getInstance().disableMonitoring();
        this.aggregateIdentifier = UUID.randomUUID();
        this.eventBus = new RecordingEventBus();
        this.commandBus = new SimpleCommandBus();
        this.commandBus.setInterceptors(Arrays.asList(new SimpleUnitOfWorkInterceptor()));
        this.eventStore = new RecordingEventStore();
        this.clearGivenWhenState();
    }

    @Override
    public <T extends EventSourcedAggregateRoot> EventSourcingRepository<T> createGenericRepository(Class<T> aggregateClass) {
        this.registerRepository((EventSourcingRepository<?>)new GenericEventSourcingRepository(aggregateClass));
        return this.repository;
    }

    @Override
    public FixtureConfiguration registerRepository(EventSourcingRepository<?> eventSourcingRepository) {
        this.repository = eventSourcingRepository;
        eventSourcingRepository.setEventBus(this.eventBus);
        eventSourcingRepository.setEventStore(this.eventStore);
        return this;
    }

    @Override
    public FixtureConfiguration registerAnnotatedCommandHandler(Object annotatedCommandHandler) {
        AnnotationCommandHandlerAdapter commandHandlerAdapter = new AnnotationCommandHandlerAdapter(annotatedCommandHandler, (CommandBus)this.commandBus);
        commandHandlerAdapter.subscribe();
        return this;
    }

    @Override
    public FixtureConfiguration registerCommandHandler(Class<?> commandType, CommandHandler commandHandler) {
        this.commandBus.subscribe(commandType, commandHandler);
        return this;
    }

    @Override
    public TestExecutor given(DomainEvent ... domainEvents) {
        return this.given(Arrays.asList(domainEvents));
    }

    @Override
    public TestExecutor given(List<DomainEvent> domainEvents) {
        this.clearGivenWhenState();
        for (DomainEvent event : domainEvents) {
            this.setByReflection(DomainEvent.class, "aggregateIdentifier", event, this.aggregateIdentifier);
            this.setByReflection(DomainEvent.class, "sequenceNumber", event, Long.valueOf(this.sequenceNumber++));
        }
        this.givenEvents.addAll(domainEvents);
        return this;
    }

    @Override
    public ResultValidator when(Object command) {
        this.commandBus.dispatch(command, (CommandCallback)new CommandCallback<Object, Object>(){

            public void onSuccess(Object result, CommandContext context) {
                GivenWhenThenTestFixture.this.actualReturnValue = result;
            }

            public void onFailure(Throwable cause, CommandContext context) {
                GivenWhenThenTestFixture.this.actualException = cause;
            }
        });
        return this;
    }

    @Override
    public ResultValidator expectEvents(DomainEvent ... expectedEvents) {
        if (this.publishedEvents.size() != this.storedEvents.size()) {
            this.reporter.reportDifferenceInStoredVsPublished(this.storedEvents, this.publishedEvents);
        }
        return this.expectPublishedEvents((Event[])expectedEvents);
    }

    @Override
    public ResultValidator expectPublishedEvents(Event ... expectedEvents) {
        if (expectedEvents.length != this.publishedEvents.size()) {
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<Event> iterator = this.publishedEvents.iterator();
        for (Event expectedEvent : expectedEvents) {
            Event actualEvent = iterator.next();
            if (this.verifyEventEquality(expectedEvent, actualEvent)) continue;
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator expectStoredEvents(DomainEvent ... expectedEvents) {
        if (expectedEvents.length != this.storedEvents.size()) {
            this.reporter.reportWrongEvent(this.storedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<DomainEvent> iterator = this.storedEvents.iterator();
        for (DomainEvent expectedEvent : expectedEvents) {
            DomainEvent actualEvent = iterator.next();
            if (this.verifyEventEquality((Event)expectedEvent, (Event)actualEvent)) continue;
            this.reporter.reportWrongEvent(this.storedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator expectVoidReturnType() {
        return this.expectReturnValue(Void.TYPE);
    }

    @Override
    public ResultValidator expectReturnValue(Object expectedReturnValue) {
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, expectedReturnValue);
        }
        if (expectedReturnValue != null && !expectedReturnValue.equals(this.actualReturnValue) || expectedReturnValue == null && this.actualReturnValue != null) {
            this.reporter.reportWrongResult(this.actualReturnValue, expectedReturnValue);
        }
        return this;
    }

    @Override
    public ResultValidator expectException(Class<? extends Throwable> expectedException) {
        if (this.actualReturnValue != null) {
            this.reporter.reportUnexpectedReturnValue(this.actualReturnValue, expectedException);
        }
        if (!expectedException.equals(this.actualException.getClass())) {
            this.reporter.reportWrongException(this.actualException, expectedException);
        }
        return this;
    }

    private void clearGivenWhenState() {
        this.storedEvents = new ArrayList<DomainEvent>();
        this.publishedEvents = new ArrayList<Event>();
        this.givenEvents = new ArrayList<DomainEvent>();
        this.sequenceNumber = 0L;
        this.actualReturnValue = null;
        this.actualException = null;
    }

    @Override
    public UUID getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    @Override
    public CommandBus getCommandBus() {
        return this.commandBus;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public EventStore getEventStore() {
        return this.eventStore;
    }

    @Override
    public EventSourcingRepository<?> getRepository() {
        return this.repository;
    }

    private boolean verifyEventEquality(Event expectedEvent, Event actualEvent) {
        if (!expectedEvent.getClass().equals(actualEvent.getClass())) {
            return false;
        }
        this.verifyEqualFields(expectedEvent.getClass(), expectedEvent, actualEvent);
        return true;
    }

    private void setByReflection(Class<?> eventClass, String fieldName, DomainEvent event, Serializable value) {
        try {
            Field field = eventClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(event, value);
        }
        catch (Exception e) {
            throw new FixtureExecutionException("This test fixture needs to be able to set fields by reflection", e);
        }
    }

    private void verifyEqualFields(Class<?> aClass, Event expectedEvent, Event actualEvent) {
        for (Field field : aClass.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object expected = field.get(expectedEvent);
                Object actual = field.get(actualEvent);
                if ((expected == null || expected.equals(actual)) && (expected != null || actual == null)) continue;
                this.reporter.reportDifferentEventContents(expectedEvent.getClass(), field, actual, expected);
            }
            catch (IllegalAccessException e) {
                throw new FixtureExecutionException("Could not confirm event equality due to an exception", e);
            }
        }
        if (aClass.getSuperclass() != DomainEvent.class && aClass.getSuperclass() != EventBase.class && aClass.getSuperclass() != Object.class) {
            this.verifyEqualFields(aClass.getSuperclass(), expectedEvent, actualEvent);
        }
    }

    private class RecordingEventBus
    implements EventBus {
        private RecordingEventBus() {
        }

        public void publish(Event event) {
            GivenWhenThenTestFixture.this.publishedEvents.add(event);
        }

        public void subscribe(EventListener eventListener) {
        }

        public void unsubscribe(EventListener eventListener) {
        }
    }

    private class RecordingEventStore
    implements EventStore {
        private RecordingEventStore() {
        }

        public void appendEvents(String type, DomainEventStream events) {
            while (events.hasNext()) {
                DomainEvent next = events.next();
                GivenWhenThenTestFixture.this.storedEvents.add(next);
            }
        }

        public DomainEventStream readEvents(String type, UUID identifier) {
            if (!GivenWhenThenTestFixture.this.aggregateIdentifier.equals(identifier)) {
                throw new EventStoreException("You probably want to use aggregateIdentifier() on your fixture to get the aggregate identifier to use");
            }
            return new SimpleDomainEventStream(GivenWhenThenTestFixture.this.givenEvents);
        }
    }
}

