/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.axonframework.common.Assert;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.ComponentOverrideException;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Components;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.DecoratorDefinition;
import org.axonframework.configuration.DuplicateModuleRegistrationException;
import org.axonframework.configuration.HierarchicalConfiguration;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.OverridePolicy;
import org.axonframework.configuration.SearchScope;
import org.axonframework.spring.config.SpringLifecycleRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.ResolvableType;

@Internal
public class SpringComponentRegistry
implements BeanPostProcessor,
BeanFactoryPostProcessor,
ComponentRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SpringLifecycleRegistry lifecycleRegistry;
    private final Components components = new Components();
    private final List<DecoratorDefinition.CompletedDecoratorDefinition<?, ?>> decorators = new CopyOnWriteArrayList();
    private final List<ConfigurationEnhancer> enhancers = new CopyOnWriteArrayList<ConfigurationEnhancer>();
    private final Map<String, Module> modules = new ConcurrentHashMap<String, Module>();
    private final List<ComponentFactory<?>> factories = new ArrayList();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Configuration configuration = new SpringConfiguration();
    private final Map<String, Configuration> moduleConfigurations = new ConcurrentHashMap<String, Configuration>();
    private boolean disableEnhancerScanning = false;
    private final List<Class<? extends ConfigurationEnhancer>> disabledEnhancers = new CopyOnWriteArrayList<Class<? extends ConfigurationEnhancer>>();
    private final List<Class<? extends ConfigurationEnhancer>> invokedEnhancers = new CopyOnWriteArrayList<Class<? extends ConfigurationEnhancer>>();
    private ConfigurableListableBeanFactory beanFactory;

    @Internal
    public SpringComponentRegistry(@Nonnull ListableBeanFactory listableBeanFactory, @Nonnull SpringLifecycleRegistry lifecycleRegistry) {
        Objects.requireNonNull(listableBeanFactory, "The ListableBeanFactory may not be null.");
        this.enhancers.addAll(listableBeanFactory.getBeansOfType(ConfigurationEnhancer.class).values());
        this.lifecycleRegistry = Objects.requireNonNull(lifecycleRegistry, "The Lifecycle Registry may not be null.");
    }

    public <C> ComponentRegistry registerComponent(@Nonnull ComponentDefinition<? extends C> definition) {
        if (!(definition instanceof ComponentDefinition.ComponentCreator)) {
            throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(definition));
        }
        ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)definition;
        Component component = creator.createComponent();
        if (this.components.contains(component.identifier())) {
            throw new ComponentOverrideException(creator.rawType(), creator.name());
        }
        this.components.put(component);
        return this;
    }

    public <C> ComponentRegistry registerDecorator(@Nonnull DecoratorDefinition<C, ? extends C> definition) {
        if (!(definition instanceof DecoratorDefinition.CompletedDecoratorDefinition)) {
            throw new IllegalArgumentException("Unsupported decorator definition type: " + String.valueOf(definition));
        }
        DecoratorDefinition.CompletedDecoratorDefinition decoratorRegistration = (DecoratorDefinition.CompletedDecoratorDefinition)definition;
        logger.debug("Registering decorator definition: [{}]", definition);
        this.decorators.add(decoratorRegistration);
        return this;
    }

    public boolean hasComponent(@Nonnull Class<?> type, @Nullable String name, @Nonnull SearchScope searchScope) {
        return switch (searchScope) {
            default -> throw new MatchException(null, null);
            case SearchScope.ALL -> {
                if (this.components.contains(new Component.Identifier(type, name)) || this.contextHasComponent(type, name)) {
                    yield true;
                }
                yield false;
            }
            case SearchScope.CURRENT -> this.components.contains(new Component.Identifier(type, name));
            case SearchScope.ANCESTORS -> this.contextHasComponent(type, name);
        };
    }

    private boolean contextHasComponent(Class<?> type, String name) {
        return name != null ? Arrays.stream(this.beanFactory.getBeanNamesForType(type)).toList().contains(name) : this.beanFactory.getBeanNamesForType(type).length > 0;
    }

    public ComponentRegistry registerEnhancer(@Nonnull ConfigurationEnhancer enhancer) {
        logger.debug("Registering enhancer [{}].", (Object)enhancer.getClass().getSimpleName());
        this.enhancers.add(enhancer);
        return this;
    }

    public ComponentRegistry registerModule(@Nonnull Module module) {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering module [{}].", (Object)module.name());
        }
        if (this.modules.containsKey(module.name())) {
            throw new DuplicateModuleRegistrationException(module);
        }
        this.modules.put(module.name(), module);
        return this;
    }

    public <C> ComponentRegistry registerFactory(@Nonnull ComponentFactory<C> factory) {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering component factory [{}].", (Object)factory.getClass().getSimpleName());
        }
        this.factories.add(factory);
        return this;
    }

    public ComponentRegistry setOverridePolicy(@Nonnull OverridePolicy overridePolicy) {
        if (overridePolicy != OverridePolicy.REJECT) {
            logger.warn("Enabling Component overriding on a Spring-based ComponentRegistry is not supported. Please use Spring \"Bean Definition Overriding Property\" instead.");
        }
        return this;
    }

    public ComponentRegistry disableEnhancerScanning() {
        this.disableEnhancerScanning = true;
        return this;
    }

    public ComponentRegistry disableEnhancer(Class<? extends ConfigurationEnhancer> enhancerClass) {
        if (this.invokedEnhancers.contains(enhancerClass)) {
            logger.warn("Disabling Configuration Enhancer [{}] won't take effect as it has already been invoked. We recommend to invoke disabling of this enhancer before it takes effect.", (Object)enhancerClass.getSimpleName());
            return this;
        }
        this.disabledEnhancers.add(enhancerClass);
        return this;
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("initialized", Boolean.valueOf(this.initialized.get()));
        descriptor.describeProperty("components", (Object)this.components);
        descriptor.describeProperty("decorators", this.decorators);
        descriptor.describeProperty("configurerEnhancers", this.enhancers);
        descriptor.describeProperty("modules", this.modules.values());
        descriptor.describeProperty("factories", this.factories);
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(@Nonnull Object bean, @Nonnull String beanName) throws BeansException {
        this.initialize();
        Component springComponent = new SpringComponent(bean, beanName);
        Component.Identifier componentId = new Component.Identifier(bean.getClass(), beanName);
        for (DecoratorDefinition.CompletedDecoratorDefinition<?, ?> decorator : this.decorators) {
            if (!decorator.matches(componentId)) continue;
            springComponent = decorator.decorate(springComponent);
        }
        return springComponent.resolve(this.configuration);
    }

    public Configuration configuration() {
        return this.configuration;
    }

    void initialize() {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        this.scanForConfigurationEnhancers();
        this.invokeEnhancers();
        this.scanForDecoratorDefinitions();
        this.decorateComponents();
        this.registerLocalComponentsWithApplicationContext();
        this.scanForModules();
        this.buildModules();
        this.scanForComponentFactories();
        this.registerFactoryShutdownHandlers();
    }

    private void scanForConfigurationEnhancers() {
        if (this.disableEnhancerScanning) {
            return;
        }
        ServiceLoader<ConfigurationEnhancer> enhancerLoader = ServiceLoader.load(ConfigurationEnhancer.class, this.getClass().getClassLoader());
        enhancerLoader.stream().map(ServiceLoader.Provider::get).filter(enhancer -> !this.disabledEnhancers.contains(enhancer.getClass())).forEach(this::registerEnhancer);
    }

    private void invokeEnhancers() {
        List<ConfigurationEnhancer> distinctAndOrderedEnhancers = this.enhancers.stream().distinct().sorted(Comparator.comparingInt(ConfigurationEnhancer::order)).toList();
        for (ConfigurationEnhancer enhancer : distinctAndOrderedEnhancers) {
            if (this.disabledEnhancers.contains(enhancer.getClass())) continue;
            enhancer.enhance((ComponentRegistry)this);
            this.invokedEnhancers.add(enhancer.getClass());
        }
    }

    private void scanForDecoratorDefinitions() {
        this.beanFactory.getBeansOfType(DecoratorDefinition.class).forEach((beanName, decorator) -> this.registerDecorator((DecoratorDefinition)decorator));
    }

    private void decorateComponents() {
        this.decorators.sort(Comparator.comparingInt(DecoratorDefinition.CompletedDecoratorDefinition::order));
        for (DecoratorDefinition.CompletedDecoratorDefinition<?, ?> decorator : this.decorators) {
            for (Component.Identifier id : this.components.identifiers()) {
                if (!decorator.matches(id)) continue;
                this.components.replace(id, arg_0 -> decorator.decorate(arg_0));
            }
        }
    }

    private void registerLocalComponentsWithApplicationContext() {
        this.components.postProcessComponents(component -> {
            String name = Objects.requireNonNullElseGet(component.identifier().name(), () -> component.identifier().typeAsClass().getName());
            if (this.beanFactory.containsBeanDefinition(name)) {
                logger.info("Component with name [{}] is already available. Skipping registration.", (Object)name);
                return;
            }
            AbstractBeanDefinition definition = BeanDefinitionBuilder.rootBeanDefinition((ResolvableType)ResolvableType.forType((Type)component.identifier().type().getType()), () -> component.resolve(this.configuration)).getBeanDefinition();
            ((BeanDefinitionRegistry)this.beanFactory).registerBeanDefinition(name, (BeanDefinition)definition);
            component.initLifecycle(this.configuration, (LifecycleRegistry)this.lifecycleRegistry);
        });
    }

    private void scanForModules() {
        this.beanFactory.getBeansOfType(Module.class).forEach((beanName, module) -> this.registerModule((Module)module));
    }

    private void buildModules() {
        for (Module module : this.modules.values()) {
            Configuration builtModule = HierarchicalConfiguration.build((LifecycleRegistry)this.lifecycleRegistry, childLifecycleRegistry -> module.build(this.configuration, childLifecycleRegistry));
            this.moduleConfigurations.put(module.name(), builtModule);
        }
    }

    private void scanForComponentFactories() {
        this.beanFactory.getBeansOfType(ComponentFactory.class).forEach((beanName, factory) -> this.registerFactory((ComponentFactory)factory));
    }

    private void registerFactoryShutdownHandlers() {
        this.factories.forEach(factory -> factory.registerShutdownHandlers((LifecycleRegistry)this.lifecycleRegistry));
    }

    private class SpringConfiguration
    implements Configuration {
        private SpringConfiguration() {
        }

        @Nonnull
        public <C> C getComponent(@Nonnull Class<C> type) {
            try {
                return (C)SpringComponentRegistry.this.beanFactory.getBean(type);
            }
            catch (NoUniqueBeanDefinitionException e) {
                Object bean = SpringComponentRegistry.this.beanFactory.getBeansOfType(type).get(type.getName());
                if (bean == null) {
                    throw e;
                }
                return (C)bean;
            }
        }

        @Nonnull
        public <C> C getComponent(@Nonnull Class<C> type, @Nullable String name) {
            Assert.notNull((Object)name, () -> "Spring does not allow the use of null names for component retrieval.");
            return (C)SpringComponentRegistry.this.beanFactory.getBean(name, type);
        }

        public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type) {
            return Optional.ofNullable(SpringComponentRegistry.this.beanFactory.getBeanProvider(type).getIfAvailable());
        }

        public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type, @Nullable String name) {
            Map beansOfType = SpringComponentRegistry.this.beanFactory.getBeansOfType(type);
            if (beansOfType.containsKey(name)) {
                return Optional.of(beansOfType.get(name));
            }
            if (name == null && beansOfType.containsKey(type.getName())) {
                return Optional.of(beansOfType.get(type.getName()));
            }
            if (name == null) {
                return this.getOptionalComponent(type);
            }
            return Optional.empty();
        }

        @Nonnull
        public <C> C getComponent(@Nonnull Class<C> type, @Nullable String name, @Nonnull Supplier<C> defaultImpl) {
            return this.getOptionalComponent(type, name).orElseGet(defaultImpl);
        }

        public List<Configuration> getModuleConfigurations() {
            return List.copyOf(SpringComponentRegistry.this.moduleConfigurations.values());
        }

        public Optional<Configuration> getModuleConfiguration(@Nonnull String name) {
            return Optional.ofNullable(SpringComponentRegistry.this.moduleConfigurations.get(name));
        }

        @Nullable
        public Configuration getParent() {
            BeanFactory parentBeanFactory = SpringComponentRegistry.this.beanFactory.getParentBeanFactory();
            if (parentBeanFactory != null) {
                return (Configuration)parentBeanFactory.getBean(Configuration.class);
            }
            return null;
        }

        public void describeTo(@Nonnull ComponentDescriptor descriptor) {
            descriptor.describeProperty("components", (Object)SpringComponentRegistry.this.components);
            descriptor.describeProperty("modules", SpringComponentRegistry.this.moduleConfigurations.values());
        }
    }

    private static final class SpringComponent<T>
    implements Component<T> {
        private final Component.Identifier<T> identifier;
        private final T bean;

        private SpringComponent(@Nonnull T bean, @Nonnull String beanName) {
            this.identifier = new Component.Identifier(bean.getClass(), beanName);
            this.bean = bean;
        }

        public Component.Identifier<T> identifier() {
            return this.identifier;
        }

        public T resolve(@Nonnull Configuration configuration) {
            return this.bean;
        }

        public boolean isInstantiated() {
            return true;
        }

        public void initLifecycle(@Nonnull Configuration configuration, @Nonnull LifecycleRegistry lifecycleRegistry) {
        }

        public boolean isInitialized() {
            return true;
        }

        public void describeTo(@Nonnull ComponentDescriptor descriptor) {
            descriptor.describeProperty("identifier", this.identifier);
            descriptor.describeProperty("bean", this.bean);
        }
    }
}

