/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventsourcing;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.AggregateSnapshotter;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.tracing.SpanFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringAggregateSnapshotter
extends AggregateSnapshotter
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    protected SpringAggregateSnapshotter(Builder builder) {
        super((AggregateSnapshotter.Builder)builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected AggregateFactory<?> getAggregateFactory(Class<?> aggregateType) {
        AggregateFactory aggregateFactory = super.getAggregateFactory(aggregateType);
        if (aggregateFactory == null) {
            Optional<AggregateFactory> factory = this.applicationContext.getBeansOfType(AggregateFactory.class).values().stream().filter(af -> Objects.equals(af.getAggregateType(), aggregateType)).findFirst();
            if (!factory.isPresent() && (factory = this.applicationContext.getBeansOfType(EventSourcingRepository.class).values().stream().map(EventSourcingRepository::getAggregateFactory).filter(af -> Objects.equals(af.getAggregateType(), aggregateType)).findFirst()).isPresent()) {
                aggregateFactory = factory.get();
                this.registerAggregateFactory(aggregateFactory);
            }
            if (factory.isPresent()) {
                aggregateFactory = factory.get();
                this.registerAggregateFactory(aggregateFactory);
            }
        }
        return aggregateFactory;
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static class Builder
    extends AggregateSnapshotter.Builder {
        public Builder() {
            this.aggregateFactories(Collections.emptyList());
        }

        public Builder eventStore(EventStore eventStore) {
            super.eventStore(eventStore);
            return this;
        }

        public Builder executor(Executor executor) {
            super.executor(executor);
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            super.transactionManager(transactionManager);
            return this;
        }

        public Builder repositoryProvider(RepositoryProvider repositoryProvider) {
            super.repositoryProvider(repositoryProvider);
            return this;
        }

        public Builder parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            super.parameterResolverFactory(parameterResolverFactory);
            return this;
        }

        public Builder handlerDefinition(HandlerDefinition handlerDefinition) {
            super.handlerDefinition(handlerDefinition);
            return this;
        }

        public Builder spanFactory(@Nonnull SpanFactory spanFactory) {
            super.spanFactory(spanFactory);
            return this;
        }

        public SpringAggregateSnapshotter build() {
            return new SpringAggregateSnapshotter(this);
        }

        protected void validate() throws AxonConfigurationException {
            super.validate();
        }
    }
}

