/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventsourcing;

import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.IncompatibleAggregateException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringPrototypeAggregateFactory<T>
implements AggregateFactory<T>,
InitializingBean,
ApplicationContextAware,
BeanNameAware {
    private String prototypeBeanName;
    private ApplicationContext applicationContext;
    private String beanName;
    private Class<T> aggregateType;
    private AggregateFactory<T> delegate;

    public T createAggregateRoot(String aggregateIdentifier, DomainEventMessage<?> firstEvent) {
        return (T)this.delegate.createAggregateRoot(aggregateIdentifier, firstEvent);
    }

    public Class<T> getAggregateType() {
        if (this.aggregateType == null) {
            this.aggregateType = this.applicationContext.getType(this.prototypeBeanName);
        }
        return this.aggregateType;
    }

    @Required
    public void setPrototypeBeanName(String prototypeBeanName) {
        this.prototypeBeanName = prototypeBeanName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        if (!this.applicationContext.isPrototype(this.prototypeBeanName)) {
            throw new IncompatibleAggregateException(String.format("Cannot initialize repository '%s'. The bean with name '%s' does not have the 'prototype' scope.", this.beanName, this.prototypeBeanName));
        }
        this.delegate = new AbstractAggregateFactory<T>(this.getAggregateType()){

            protected T doCreateAggregate(String aggregateIdentifier, DomainEventMessage firstEvent) {
                return SpringPrototypeAggregateFactory.this.applicationContext.getBean(SpringPrototypeAggregateFactory.this.prototypeBeanName);
            }

            protected T postProcessInstance(T aggregate) {
                SpringPrototypeAggregateFactory.this.applicationContext.getAutowireCapableBeanFactory().configureBean(aggregate, SpringPrototypeAggregateFactory.this.prototypeBeanName);
                return aggregate;
            }
        };
    }
}

