/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.axonframework.messaging.annotation.ClasspathHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerEnhancerDefinition;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringHandlerEnhancerDefinitionBean
implements FactoryBean<HandlerEnhancerDefinition>,
BeanClassLoaderAware,
InitializingBean,
ApplicationContextAware {
    private final List<HandlerEnhancerDefinition> enhancers = new ArrayList<HandlerEnhancerDefinition>();
    private ClassLoader classLoader;
    private ApplicationContext applicationContext;

    public SpringHandlerEnhancerDefinitionBean() {
    }

    public SpringHandlerEnhancerDefinitionBean(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.initialize();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public HandlerEnhancerDefinition getObject() {
        return MultiHandlerEnhancerDefinition.ordered(this.enhancers);
    }

    public Class<?> getObjectType() {
        return HandlerEnhancerDefinition.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAdditionalHandlers(List<HandlerEnhancerDefinition> additionalFactories) {
        this.enhancers.addAll(additionalFactories);
    }

    private void initialize() {
        this.enhancers.addAll(ClasspathHandlerEnhancerDefinition.forClassLoader((ClassLoader)this.classLoader).getDelegates());
        Map enhancersFound = this.applicationContext.getBeansOfType(HandlerEnhancerDefinition.class);
        this.enhancers.addAll(enhancersFound.values());
    }
}

