/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.List;
import java.util.function.Supplier;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.saga.ResourceInjector;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.spring.config.NoBeanOfType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration(value="org.axonframework.spring.config.AxonConfiguration")
public class AxonConfiguration
implements Configuration,
InitializingBean,
ApplicationContextAware,
SmartLifecycle {
    private Configuration config;
    private final Configurer configurer;
    private volatile boolean running = false;

    public AxonConfiguration(Configurer configurer) {
        this.configurer = configurer;
    }

    @NoBeanOfType(value=CommandBus.class)
    @Bean
    public CommandBus commandBus() {
        return this.config.commandBus();
    }

    @NoBeanOfType(value=EventBus.class)
    @Bean
    public EventBus eventBus() {
        return this.config.eventBus();
    }

    public ResourceInjector resourceInjector() {
        return this.config.resourceInjector();
    }

    @NoBeanOfType(value=CommandGateway.class)
    @Bean
    public CommandGateway commandGateway(CommandBus commandBus) {
        return new DefaultCommandGateway(commandBus, new MessageDispatchInterceptor[0]);
    }

    public <T> Repository<T> repository(Class<T> aggregateType) {
        return this.config.repository(aggregateType);
    }

    public <T> T getComponent(Class<T> componentType, Supplier<T> defaultImpl) {
        return (T)this.config.getComponent(componentType, defaultImpl);
    }

    public <M extends Message<?>> MessageMonitor<? super M> messageMonitor(Class<?> componentType, String componentName) {
        return this.config.messageMonitor(componentType, componentName);
    }

    public List<CorrelationDataProvider> correlationDataProviders() {
        return this.config.correlationDataProviders();
    }

    public void onStart(Runnable startHandler) {
        this.config.onStart(startHandler);
    }

    public void onShutdown(Runnable shutdownHandler) {
        this.config.onShutdown(shutdownHandler);
    }

    public void start() {
        this.config.start();
        this.running = true;
    }

    public void shutdown() {
        this.config.shutdown();
    }

    public void stop() {
        this.shutdown();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 0;
    }

    public void afterPropertiesSet() throws Exception {
        this.config = this.configurer.buildConfiguration();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.configurer.registerComponent(ApplicationContext.class, c -> applicationContext);
    }
}

