/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Conditional(value={NoBeanOfTypeDefined.class})
public @interface NoBeanOfType {
    public Class<?> value();

    public static class NoBeanOfTypeDefined
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Map attributes = metadata.getAnnotationAttributes(NoBeanOfType.class.getName(), false);
            Class clazz = (Class)attributes.get("value");
            return context.getBeanFactory().getBeanNamesForType(clazz).length == 0;
        }
    }
}

