/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventsourcing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.axonframework.common.DirectExecutor;
import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.common.annotation.MultiParameterResolverFactory;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.AggregateSnapshotter;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.spring.config.annotation.SpringBeanParameterResolverFactory;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringAggregateSnapshotterFactoryBean
implements FactoryBean<AggregateSnapshotter>,
ApplicationContextAware {
    private PlatformTransactionManager transactionManager;
    private boolean autoDetectAggregateFactories = true;
    private ApplicationContext applicationContext;
    private TransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    private EventStorageEngine eventStorage;
    private Executor executor = DirectExecutor.INSTANCE;
    private List<AggregateFactory<?>> aggregateFactories = new ArrayList();
    private ParameterResolverFactory parameterResolverFactory;

    public AggregateSnapshotter getObject() throws Exception {
        Map candidates;
        ArrayList factoriesFound = new ArrayList(this.aggregateFactories);
        if (this.autoDetectAggregateFactories) {
            this.applicationContext.getBeansOfType(AggregateFactory.class).values().forEach(factoriesFound::add);
            Collection eventSourcingRepositories = this.applicationContext.getBeansOfType(EventSourcingRepository.class).values();
            for (EventSourcingRepository repo : eventSourcingRepositories) {
                factoriesFound.add(repo.getAggregateFactory());
            }
        }
        if (this.transactionManager == null && (candidates = this.applicationContext.getBeansOfType(PlatformTransactionManager.class)).size() == 1) {
            this.transactionManager = (PlatformTransactionManager)candidates.values().iterator().next();
        }
        if (this.eventStorage == null) {
            this.eventStorage = (EventStorageEngine)this.applicationContext.getBean(EventStorageEngine.class);
        }
        if (this.parameterResolverFactory == null) {
            this.parameterResolverFactory = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{ClasspathParameterResolverFactory.forClass(this.getObjectType()), new SpringBeanParameterResolverFactory(this.applicationContext)});
        }
        Object txManager = this.transactionManager == null ? NoTransactionManager.INSTANCE : new SpringTransactionManager(this.transactionManager, this.transactionDefinition);
        return new AggregateSnapshotter(this.eventStorage, factoriesFound, this.parameterResolverFactory, this.executor, (TransactionManager)txManager);
    }

    public Class<?> getObjectType() {
        return AggregateSnapshotter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }

    public void setAggregateFactories(List<AggregateFactory<?>> aggregateFactories) {
        this.autoDetectAggregateFactories = false;
        this.aggregateFactories.addAll(aggregateFactories);
    }

    public void setEventStorageEngine(EventStorageEngine eventStorageEngine) {
        this.eventStorage = eventStorageEngine;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

