/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import org.axonframework.commandhandling.AggregateAnnotationCommandHandler;
import org.axonframework.commandhandling.AnnotationCommandTargetResolver;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.common.annotation.MultiParameterResolverFactory;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.spring.config.annotation.SpringBeanParameterResolverFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AggregateAnnotationCommandHandlerFactoryBean<T>
implements FactoryBean<AggregateAnnotationCommandHandler<T>>,
InitializingBean,
ApplicationContextAware {
    private CommandBus commandBus;
    private Class<T> aggregateType;
    private Repository<T> repository;
    private CommandTargetResolver commandTargetResolver = new AnnotationCommandTargetResolver();
    private ParameterResolverFactory parameterResolverFactory;
    private AggregateAnnotationCommandHandler<T> handler;
    private ApplicationContext applicationContext;

    public AggregateAnnotationCommandHandler<T> getObject() throws Exception {
        return this.handler;
    }

    public Class<?> getObjectType() {
        return AggregateAnnotationCommandHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.parameterResolverFactory == null) {
            SpringBeanParameterResolverFactory springBeanParameterResolverFactory = new SpringBeanParameterResolverFactory();
            springBeanParameterResolverFactory.setApplicationContext(this.applicationContext);
            this.parameterResolverFactory = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{ClasspathParameterResolverFactory.forClass(this.aggregateType), springBeanParameterResolverFactory});
        }
        this.handler = new AggregateAnnotationCommandHandler(this.aggregateType, this.repository, this.commandTargetResolver, this.parameterResolverFactory);
        this.handler.subscribe(this.commandBus);
    }

    @Required
    public void setCommandBus(CommandBus commandBus) {
        this.commandBus = commandBus;
    }

    @Required
    public void setAggregateType(Class<T> aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Required
    public void setRepository(Repository<T> repository) {
        this.repository = repository;
    }

    public void setCommandTargetResolver(CommandTargetResolver commandTargetResolver) {
        this.commandTargetResolver = commandTargetResolver;
    }

    public void setParameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
        this.parameterResolverFactory = parameterResolverFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

