/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import jakarta.persistence.EntityManagerFactory;
import java.sql.SQLException;
import java.time.temporal.TemporalAmount;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.eventhandling.processors.streaming.token.store.TokenStore;
import org.axonframework.eventhandling.processors.streaming.token.store.jpa.JpaTokenStore;
import org.axonframework.eventsourcing.eventstore.jpa.SQLErrorCodesResolver;
import org.axonframework.serialization.Serializer;
import org.axonframework.springboot.TokenStoreProperties;
import org.axonframework.springboot.util.RegisterDefaultEntities;
import org.axonframework.springboot.util.jpa.ContainerManagedEntityManagerProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnBean(value={EntityManagerFactory.class})
@EnableConfigurationProperties(value={TokenStoreProperties.class})
@RegisterDefaultEntities(packages={"org.axonframework.eventhandling.tokenstore", "org.axonframework.eventhandling.deadletter.jpa", "org.axonframework.modelling.saga.repository.jpa"})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
public class JpaAutoConfiguration {
    private final TokenStoreProperties tokenStoreProperties;

    public JpaAutoConfiguration(TokenStoreProperties tokenStoreProperties) {
        this.tokenStoreProperties = tokenStoreProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityManagerProvider entityManagerProvider() {
        return new ContainerManagedEntityManagerProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenStore tokenStore(Serializer serializer, EntityManagerProvider entityManagerProvider) {
        return JpaTokenStore.builder().entityManagerProvider(entityManagerProvider).serializer(serializer).claimTimeout((TemporalAmount)this.tokenStoreProperties.getClaimTimeout()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    public PersistenceExceptionResolver persistenceExceptionResolver(DataSource dataSource) throws SQLException {
        return new SQLErrorCodesResolver(dataSource);
    }
}

