/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import io.axoniq.axonserver.connector.event.PersistentStreamProperties;
import java.util.concurrent.ScheduledExecutorService;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.event.axon.DefaultPersistentStreamMessageSourceFactory;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSourceDefinition;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSourceFactory;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamScheduledExecutorBuilder;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.springboot.EventProcessorProperties;
import org.axonframework.springboot.autoconfig.PersistentStreamMessageSourceRegistrar;
import org.axonframework.springboot.util.ConditionalOnMissingQualifiedBean;
import org.axonframework.springboot.util.ConditionalOnQualifiedBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
public class PersistentStreamAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingQualifiedBean(beanClass=ScheduledExecutorService.class, qualifier="persistentStreamScheduler")
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public PersistentStreamScheduledExecutorBuilder persistentStreamScheduledExecutorBuilder() {
        return PersistentStreamScheduledExecutorBuilder.defaultFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnQualifiedBean(beanClass=ScheduledExecutorService.class, qualifier="persistentStreamScheduler")
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public PersistentStreamScheduledExecutorBuilder backwardsCompatiblePersistentStreamScheduledExecutorBuilder(@Qualifier(value="persistentStreamScheduler") ScheduledExecutorService persistentStreamScheduler) {
        return (threadCount, streamName) -> persistentStreamScheduler;
    }

    @Bean
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public PersistentStreamMessageSourceRegistrar persistentStreamRegistrar(Environment environment, PersistentStreamScheduledExecutorBuilder executorBuilder) {
        return new PersistentStreamMessageSourceRegistrar(environment, executorBuilder);
    }

    @Bean
    @ConditionalOnProperty(name={"axon.axonserver.auto-persistent-streams-enable"})
    public ConfigurerModule autoPersistentStreamMessageSourceDefinitionBuilder(PersistentStreamScheduledExecutorBuilder executorBuilder, PersistentStreamMessageSourceFactory psFactory, AxonServerConfiguration axonServerConfiguration) {
        AxonServerConfiguration.PersistentStreamSettings psSettings = axonServerConfiguration.getAutoPersistentStreamsSettings();
        return configurer -> configurer.eventProcessing().usingSubscribingEventProcessors(processingGroupName -> {
            String psName = processingGroupName + "-stream";
            return new PersistentStreamMessageSourceDefinition(processingGroupName, new PersistentStreamProperties(psName, psSettings.getInitialSegmentCount(), psSettings.getSequencingPolicy(), psSettings.getSequencingPolicyParameters(), psSettings.getInitialPosition(), psSettings.getFilter()), executorBuilder.build(Integer.valueOf(psSettings.getThreadCount()), psName), psSettings.getBatchSize(), null, psFactory);
        });
    }

    @Bean
    @ConditionalOnMissingBean
    public PersistentStreamMessageSourceFactory persistentStreamMessageSourceFactory() {
        return new DefaultPersistentStreamMessageSourceFactory();
    }

    @Bean
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public ConfigurerModule persistentStreamProcessorsConfigurerModule(EventProcessorProperties processorProperties, AxonServerConfiguration axonServerConfiguration) {
        return configurer -> configurer.eventProcessing(processingConfigurer -> processorProperties.getProcessors().entrySet().stream().filter(e -> ((EventProcessorProperties.ProcessorSettings)e.getValue()).getMode().equals((Object)EventProcessorProperties.Mode.SUBSCRIBING)).filter(e -> ((EventProcessorProperties.ProcessorSettings)e.getValue()).getDlq().isEnabled()).filter(e -> axonServerConfiguration.getPersistentStreams().containsKey(((EventProcessorProperties.ProcessorSettings)e.getValue()).getSource())).forEach(e -> {
            AxonServerConfiguration.PersistentStreamSettings persistentStreamConfig = (AxonServerConfiguration.PersistentStreamSettings)axonServerConfiguration.getPersistentStreams().get(((EventProcessorProperties.ProcessorSettings)e.getValue()).getSource());
            processingConfigurer.registerSequencingPolicy((String)e.getKey(), null);
        }));
    }
}

