/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.message.SchemaStore;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.conversion.DelegatingEventConverter;
import org.axonframework.eventhandling.conversion.EventConverter;
import org.axonframework.messaging.conversion.DelegatingMessageConverter;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.serialization.ChainingContentTypeConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.avro.AvroSerializer;
import org.axonframework.serialization.avro.AvroSerializerStrategy;
import org.axonframework.serialization.json.JacksonConverter;
import org.axonframework.springboot.ConverterProperties;
import org.axonframework.springboot.autoconfig.AxonAutoConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@AutoConfigureBefore(value={AxonAutoConfiguration.class})
@EnableConfigurationProperties(value={ConverterProperties.class})
public class ConverterAutoConfiguration
implements ApplicationContextAware,
BeanClassLoaderAware {
    private ApplicationContext applicationContext;
    private ClassLoader classLoader;

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public Converter converter(ConverterProperties converterProperties) {
        ConverterProperties.ConverterType generalConverterType = converterProperties.getGeneral();
        if (ConverterProperties.ConverterType.AVRO == generalConverterType) {
            throw new AxonConfigurationException(String.format("Invalid converter type [%s] configured as general converter. The Avro Converter can be used as message or event serializer only.", generalConverterType.name()));
        }
        return this.buildConverter(generalConverterType, null);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageConverter messageConverter(Converter generalConverter, ConverterProperties converterProperties) {
        ConverterProperties.ConverterType messagesConverterType = converterProperties.getMessages();
        if (ConverterProperties.ConverterType.DEFAULT == messagesConverterType || converterProperties.getGeneral() == messagesConverterType) {
            return new DelegatingMessageConverter(generalConverter);
        }
        return new DelegatingMessageConverter(this.buildConverter(messagesConverterType, generalConverter));
    }

    @Bean
    @ConditionalOnMissingBean
    public EventConverter eventConverter(Converter generalConverter, MessageConverter messageConverter, ConverterProperties converterProperties) {
        ConverterProperties.ConverterType eventsConverterType = converterProperties.getEvents();
        if (ConverterProperties.ConverterType.DEFAULT == eventsConverterType || converterProperties.getMessages() == eventsConverterType) {
            return new DelegatingEventConverter(messageConverter);
        }
        if (converterProperties.getGeneral() == eventsConverterType) {
            return new DelegatingEventConverter(generalConverter);
        }
        return new DelegatingEventConverter(this.buildConverter(eventsConverterType, generalConverter));
    }

    @Nonnull
    private Converter buildConverter(@Nonnull ConverterProperties.ConverterType converterType, @Nullable Converter generalConverter) {
        switch (converterType) {
            case AVRO: {
                if (generalConverter == null) {
                    throw new AxonConfigurationException("General serializer is mandatory as a fallback Avro Converter, but none was provided.");
                }
                Map schemaStoreBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, SchemaStore.class);
                SchemaStore schemaStore = schemaStoreBeans.containsKey("defaultAxonSchemaStore") ? (SchemaStore)schemaStoreBeans.get("defaultAxonSchemaStore") : (SchemaStore)schemaStoreBeans.values().stream().findFirst().orElseThrow(() -> new NoSuchBeanDefinitionException(SchemaStore.class));
                Map serializationStrategies = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, AvroSerializerStrategy.class);
                AvroSerializer.Builder builder = AvroSerializer.builder().schemaStore(schemaStore);
                serializationStrategies.values().forEach(arg_0 -> ((AvroSerializer.Builder)builder).addSerializerStrategy(arg_0));
                return null;
            }
            case CBOR: {
                Map cborMapperBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, CBORMapper.class);
                ObjectMapper cborMapper = cborMapperBeans.containsKey("defaultAxonCborObjectMapper") ? (ObjectMapper)cborMapperBeans.get("defaultAxonCborObjectMapper") : (ObjectMapper)cborMapperBeans.values().stream().findFirst().orElseThrow(() -> new NoSuchBeanDefinitionException(CBORMapper.class));
                return new JacksonConverter(cborMapper, new ChainingContentTypeConverter(this.classLoader));
            }
        }
        Map objectMapperBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ObjectMapper.class);
        ObjectMapper objectMapper = objectMapperBeans.containsKey("defaultAxonObjectMapper") ? (ObjectMapper)objectMapperBeans.get("defaultAxonObjectMapper") : (ObjectMapper)objectMapperBeans.values().stream().findFirst().orElseThrow(() -> new NoSuchBeanDefinitionException(ObjectMapper.class));
        return new JacksonConverter(objectMapper, new ChainingContentTypeConverter(this.classLoader));
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = Objects.requireNonNull(applicationContext, "The ApplicationContext cannot be null.");
    }

    public void setBeanClassLoader(@Nonnull ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "The ClassLoader cannot be null.");
    }
}

