/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.util;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.config.LegacyConfigurer;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.springboot.EventProcessorProperties;

public class DeadLetterQueueProviderConfigurerModule
implements ConfigurerModule {
    private final EventProcessorProperties eventProcessorProperties;
    private final Function<String, Function<LegacyConfiguration, SequencedDeadLetterQueue<EventMessage<?>>>> deadLetterQueueProvider;

    public DeadLetterQueueProviderConfigurerModule(EventProcessorProperties eventProcessorProperties, Function<String, Function<LegacyConfiguration, SequencedDeadLetterQueue<EventMessage<?>>>> deadLetterQueueProvider) {
        this.eventProcessorProperties = eventProcessorProperties;
        this.deadLetterQueueProvider = deadLetterQueueProvider;
    }

    public void configureModule(@Nonnull LegacyConfigurer configurer) {
        configurer.eventProcessing().registerDeadLetterQueueProvider(processingGroup -> this.dlqEnabled((String)processingGroup) ? this.deadLetterQueueProvider.apply((String)processingGroup) : null);
    }

    private boolean dlqEnabled(String processingGroup) {
        return this.dlqEnabled(this.eventProcessorProperties.getProcessors(), processingGroup);
    }

    private boolean dlqEnabled(Map<String, EventProcessorProperties.ProcessorSettings> processorSettings, String processingGroup) {
        return Optional.ofNullable(processorSettings.get(processingGroup)).map(EventProcessorProperties.ProcessorSettings::getDlq).map(EventProcessorProperties.Dlq::isEnabled).orElse(false);
    }
}

