/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import io.axoniq.axonserver.connector.event.PersistentStreamProperties;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.UnaryOperator;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.ManagedChannelCustomizer;
import org.axonframework.axonserver.connector.TargetContextResolver;
import org.axonframework.axonserver.connector.event.axon.AxonServerEventScheduler;
import org.axonframework.axonserver.connector.event.axon.DefaultPersistentStreamMessageSourceFactory;
import org.axonframework.axonserver.connector.event.axon.EventProcessorInfoConfiguration;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSourceDefinition;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSourceFactory;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamScheduledExecutorBuilder;
import org.axonframework.axonserver.connector.query.QueryPriorityCalculator;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.distributed.PriorityResolver;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.serialization.Serializer;
import org.axonframework.springboot.EventProcessorProperties;
import org.axonframework.springboot.TagsConfigurationProperties;
import org.axonframework.springboot.autoconfig.LegacyAxonAutoConfiguration;
import org.axonframework.springboot.autoconfig.PersistentStreamMessageSourceRegistrar;
import org.axonframework.springboot.service.connection.AxonServerConnectionDetails;
import org.axonframework.springboot.service.connection.PropertiesAxonServerConnectionDetails;
import org.axonframework.springboot.util.ConditionalOnMissingQualifiedBean;
import org.axonframework.springboot.util.ConditionalOnQualifiedBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;

@AutoConfiguration
@AutoConfigureBefore(value={LegacyAxonAutoConfiguration.class})
@ConditionalOnClass(value={AxonServerConfiguration.class})
@EnableConfigurationProperties(value={TagsConfigurationProperties.class})
@ConditionalOnProperty(name={"axon.axonserver.enabled"}, matchIfMissing=true)
public class AxonServerAutoConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Bean
    public AxonServerConfiguration axonServerConfiguration() {
        AxonServerConfiguration configuration = new AxonServerConfiguration();
        configuration.setComponentName(AxonServerAutoConfiguration.clientName(this.applicationContext.getId()));
        return configuration;
    }

    private static String clientName(@Nullable String id) {
        if (id == null) {
            return "Unnamed";
        }
        if (id.contains(":")) {
            return id.substring(0, id.indexOf(":"));
        }
        return id;
    }

    @Bean
    @ConditionalOnMissingBean
    public ManagedChannelCustomizer managedChannelCustomizer() {
        return ManagedChannelCustomizer.identity();
    }

    @Bean
    @ConditionalOnMissingBean
    public RoutingStrategy routingStrategy() {
        return new AnnotationRoutingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public PriorityResolver<CommandMessage<?>> commandPriorityCalculator() {
        return message -> 0;
    }

    @Bean
    @ConditionalOnMissingBean
    public QueryPriorityCalculator queryPriorityCalculator() {
        return QueryPriorityCalculator.defaultQueryPriorityCalculator();
    }

    @Bean
    @ConditionalOnMissingBean
    public QueryInvocationErrorHandler queryInvocationErrorHandler() {
        return LoggingQueryInvocationErrorHandler.builder().build();
    }

    @ConditionalOnMissingBean
    @Bean
    public TargetContextResolver<Message<?>> targetContextResolver() {
        return TargetContextResolver.noOp();
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.axonframework.extensions.multitenancy.autoconfig.MultiTenancyAxonServerAutoConfiguration"})
    public EventProcessorInfoConfiguration processorInfoConfiguration(EventProcessingConfiguration eventProcessingConfiguration, AxonServerConnectionManager connectionManager, AxonServerConfiguration configuration) {
        return new EventProcessorInfoConfiguration(null, c -> connectionManager, c -> configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public EventScheduler eventScheduler(@Qualifier(value="eventSerializer") Serializer eventSerializer, AxonServerConnectionManager connectionManager) {
        return AxonServerEventScheduler.builder().eventSerializer(eventSerializer).connectionManager(connectionManager).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingQualifiedBean(beanClass=ScheduledExecutorService.class, qualifier="persistentStreamScheduler")
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public PersistentStreamScheduledExecutorBuilder persistentStreamScheduledExecutorBuilder() {
        return PersistentStreamScheduledExecutorBuilder.defaultFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnQualifiedBean(beanClass=ScheduledExecutorService.class, qualifier="persistentStreamScheduler")
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public PersistentStreamScheduledExecutorBuilder backwardsCompatiblePersistentStreamScheduledExecutorBuilder(@Qualifier(value="persistentStreamScheduler") ScheduledExecutorService persistentStreamScheduler) {
        return (threadCount, streamName) -> persistentStreamScheduler;
    }

    @Bean
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public PersistentStreamMessageSourceRegistrar persistentStreamRegistrar(Environment environment, PersistentStreamScheduledExecutorBuilder executorBuilder) {
        return new PersistentStreamMessageSourceRegistrar(environment, executorBuilder);
    }

    @Bean
    @ConditionalOnProperty(name={"axon.axonserver.auto-persistent-streams-enable"})
    public ConfigurerModule autoPersistentStreamMessageSourceDefinitionBuilder(PersistentStreamScheduledExecutorBuilder executorBuilder, PersistentStreamMessageSourceFactory psFactory, AxonServerConfiguration axonServerConfiguration) {
        AxonServerConfiguration.PersistentStreamSettings psSettings = axonServerConfiguration.getAutoPersistentStreamsSettings();
        return configurer -> configurer.eventProcessing().usingSubscribingEventProcessors(processingGroupName -> {
            String psName = processingGroupName + "-stream";
            return new PersistentStreamMessageSourceDefinition(processingGroupName, new PersistentStreamProperties(psName, psSettings.getInitialSegmentCount(), psSettings.getSequencingPolicy(), psSettings.getSequencingPolicyParameters(), psSettings.getInitialPosition(), psSettings.getFilter()), executorBuilder.build(Integer.valueOf(psSettings.getThreadCount()), psName), psSettings.getBatchSize(), null, psFactory);
        });
    }

    @Bean
    @ConditionalOnMissingBean
    public PersistentStreamMessageSourceFactory persistentStreamMessageSourceFactory() {
        return new DefaultPersistentStreamMessageSourceFactory();
    }

    @Bean
    @ConditionalOnProperty(name={"axon.axonserver.event-store.enabled"}, matchIfMissing=true)
    public ConfigurerModule persistentStreamProcessorsConfigurerModule(EventProcessorProperties processorProperties, AxonServerConfiguration axonServerConfiguration) {
        return configurer -> configurer.eventProcessing(processingConfigurer -> processorProperties.getProcessors().entrySet().stream().filter(e -> ((EventProcessorProperties.ProcessorSettings)e.getValue()).getMode().equals((Object)EventProcessorProperties.Mode.SUBSCRIBING)).filter(e -> ((EventProcessorProperties.ProcessorSettings)e.getValue()).getDlq().isEnabled()).filter(e -> axonServerConfiguration.getPersistentStreams().containsKey(((EventProcessorProperties.ProcessorSettings)e.getValue()).getSource())).forEach(e -> {
            AxonServerConfiguration.PersistentStreamSettings persistentStreamConfig = (AxonServerConfiguration.PersistentStreamSettings)axonServerConfiguration.getPersistentStreams().get(((EventProcessorProperties.ProcessorSettings)e.getValue()).getSource());
            processingConfigurer.registerSequencingPolicy((String)e.getKey(), null);
        }));
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.boot.autoconfigure.service.connection.ConnectionDetails"})
    public static class ConnectionDetailsConnectionManagerConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={AxonServerConnectionDetails.class})
        PropertiesAxonServerConnectionDetails axonServerConnectionDetails(AxonServerConfiguration configuration) {
            return new PropertiesAxonServerConnectionDetails(configuration);
        }

        @Bean
        public AxonServerConnectionManager platformConnectionManager(AxonServerConnectionDetails connectionDetails, AxonServerConfiguration axonServerConfig, TagsConfigurationProperties tagProperties, ManagedChannelCustomizer managedChannelCustomizer) {
            return AxonServerConnectionManager.builder().routingServers(connectionDetails.routingServers()).axonServerConfiguration(axonServerConfig).tagsConfiguration(tagProperties.toTagsConfiguration()).channelCustomizer((UnaryOperator)managedChannelCustomizer).build();
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.boot.autoconfigure.service.connection.ConnectionDetails"})
    public static class DefaultConnectionManagerConfiguration {
        @Bean
        public AxonServerConnectionManager platformConnectionManager(AxonServerConfiguration axonServerConfig, TagsConfigurationProperties tagProperties, ManagedChannelCustomizer managedChannelCustomizer) {
            return AxonServerConnectionManager.builder().routingServers(axonServerConfig.getServers()).axonServerConfiguration(axonServerConfig).tagsConfiguration(tagProperties.toTagsConfiguration()).channelCustomizer((UnaryOperator)managedChannelCustomizer).build();
        }
    }
}

