/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.util;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.springboot.EventProcessorProperties;

public class DeadLetterQueueProviderConfigurerModule
implements ConfigurerModule {
    private final EventProcessorProperties eventProcessorProperties;
    private final Function<String, Function<Configuration, SequencedDeadLetterQueue<EventMessage<?>>>> deadLetterQueueProvider;

    public DeadLetterQueueProviderConfigurerModule(EventProcessorProperties eventProcessorProperties, Function<String, Function<Configuration, SequencedDeadLetterQueue<EventMessage<?>>>> deadLetterQueueProvider) {
        this.eventProcessorProperties = eventProcessorProperties;
        this.deadLetterQueueProvider = deadLetterQueueProvider;
    }

    public void configureModule(@Nonnull Configurer configurer) {
        configurer.eventProcessing().registerDeadLetterQueueProvider(processingGroup -> this.dlqEnabled(this.eventProcessorProperties.getProcessors(), (String)processingGroup) ? this.deadLetterQueueProvider.apply((String)processingGroup) : null);
    }

    private boolean dlqEnabled(Map<String, EventProcessorProperties.ProcessorSettings> processorSettings, String processingGroup) {
        return Optional.ofNullable(processorSettings.get(processingGroup)).map(EventProcessorProperties.ProcessorSettings::getDlq).map(EventProcessorProperties.Dlq::isEnabled).orElse(false);
    }
}

