/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import org.axonframework.springboot.TracingProperties;
import org.axonframework.springboot.autoconfig.AxonAutoConfiguration;
import org.axonframework.springboot.autoconfig.AxonTracingAutoConfiguration;
import org.axonframework.tracing.NestingSpanFactory;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.opentelemetry.OpenTelemetrySpanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureBefore(value={AxonTracingAutoConfiguration.class, AxonAutoConfiguration.class})
@ConditionalOnClass(name={"org.axonframework.tracing.opentelemetry.OpenTelemetrySpanFactory"})
public class OpenTelemetryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SpanFactory.class})
    public SpanFactory spanFactory(TracingProperties properties) {
        OpenTelemetrySpanFactory spanFactory = OpenTelemetrySpanFactory.builder().build();
        if (properties.isNestedHandlers()) {
            return NestingSpanFactory.builder().delegate((SpanFactory)spanFactory).timeLimit(properties.getNestedTimeLimit()).build();
        }
        return spanFactory;
    }
}

