/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import java.util.List;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.springboot.TracingProperties;
import org.axonframework.springboot.autoconfig.AxonAutoConfiguration;
import org.axonframework.springboot.autoconfig.AxonServerAutoConfiguration;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TracingHandlerEnhancerDefinition;
import org.axonframework.tracing.attributes.AggregateIdentifierSpanAttributesProvider;
import org.axonframework.tracing.attributes.MessageIdSpanAttributesProvider;
import org.axonframework.tracing.attributes.MessageNameSpanAttributesProvider;
import org.axonframework.tracing.attributes.MessageTypeSpanAttributesProvider;
import org.axonframework.tracing.attributes.MetadataSpanAttributesProvider;
import org.axonframework.tracing.attributes.PayloadTypeSpanAttributesProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={AxonServerAutoConfiguration.class, AxonAutoConfiguration.class})
@EnableConfigurationProperties(value={TracingProperties.class})
public class AxonTracingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SpanFactory.class})
    public SpanFactory spanFactory() {
        return NoOpSpanFactory.INSTANCE;
    }

    @Bean
    public HandlerEnhancerDefinition tracingHandlerEnhancerDefinition(SpanFactory spanFactory, TracingProperties properties) {
        return TracingHandlerEnhancerDefinition.builder().spanFactory(spanFactory).showEventSourcingHandlers(properties.isShowEventSourcingHandlers()).build();
    }

    @Bean
    public ConfigurerModule configurerModuleForTracing(List<SpanAttributesProvider> spanAttributesProviders) {
        return configurer -> configurer.onInitialize(config -> {
            SpanFactory spanFactory = config.spanFactory();
            spanAttributesProviders.forEach(arg_0 -> ((SpanFactory)spanFactory).registerSpanAttributeProvider(arg_0));
        });
    }

    @Bean
    @ConditionalOnProperty(value={"axon.tracing.attribute-providers.aggregate-identifier"}, havingValue="true", matchIfMissing=true)
    public SpanAttributesProvider aggregateIdentifierSpanAttributesProvider() {
        return new AggregateIdentifierSpanAttributesProvider();
    }

    @Bean
    @ConditionalOnProperty(value={"axon.tracing.attribute-providers.message-id"}, havingValue="true", matchIfMissing=true)
    public SpanAttributesProvider messageIdSpanAttributesProvider() {
        return new MessageIdSpanAttributesProvider();
    }

    @Bean
    @ConditionalOnProperty(value={"axon.tracing.attribute-providers.message-name"}, havingValue="true", matchIfMissing=true)
    public SpanAttributesProvider messageNameSpanAttributesProvider() {
        return new MessageNameSpanAttributesProvider();
    }

    @Bean
    @ConditionalOnProperty(value={"axon.tracing.attribute-providers.message-type"}, havingValue="true", matchIfMissing=true)
    public SpanAttributesProvider messageTypeSpanAttributesProvider() {
        return new MessageTypeSpanAttributesProvider();
    }

    @Bean
    @ConditionalOnProperty(value={"axon.tracing.attribute-providers.metadata"}, havingValue="true", matchIfMissing=true)
    public SpanAttributesProvider metadataSpanAttributesProvider() {
        return new MetadataSpanAttributesProvider();
    }

    @Bean
    @ConditionalOnProperty(value={"axon.tracing.attribute-providers.payload-type"}, havingValue="true", matchIfMissing=true)
    public SpanAttributesProvider payloadTypeSpanAttributesProvider() {
        return new PayloadTypeSpanAttributesProvider();
    }
}

