/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.util;

import com.thoughtworks.xstream.XStream;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;

public abstract class XStreamSecurityTypeUtility {
    private static final String PACKAGES_AND_SUBPACKAGES_WILDCARD = ".**";

    public static void allowTypesFromComponentScanAnnotatedBeans(ApplicationContext applicationContext, XStream xStream) {
        applicationContext.getBeansWithAnnotation(ComponentScan.class).forEach((beanName, bean) -> {
            ComponentScan ann = (ComponentScan)applicationContext.findAnnotationOnBean(beanName, ComponentScan.class);
            if (!Objects.nonNull(ann)) {
                throw new IllegalArgumentException("The ApplicationContext retrieved a bean of name [" + beanName + "] and type [" + bean.getClass() + "] for the ComponentScan annotation which does not contain the ComponentScan annotation.");
            }
            if (XStreamSecurityTypeUtility.isEmptyAnnotation(ann)) {
                xStream.allowTypesByWildcard(new String[]{bean.getClass().getPackage().getName() + PACKAGES_AND_SUBPACKAGES_WILDCARD});
            } else {
                xStream.allowTypes(ann.basePackageClasses());
                if (ann.basePackages().length != 0) {
                    XStreamSecurityTypeUtility.allowPackages(xStream, ann.basePackages());
                } else {
                    XStreamSecurityTypeUtility.allowPackages(xStream, ann.value());
                }
            }
        });
    }

    private static boolean isEmptyAnnotation(ComponentScan ann) {
        return ann.basePackageClasses().length == 0 && ann.basePackages().length == 0 && ann.value().length == 0;
    }

    private static void allowPackages(XStream xStream, String[] basePackages) {
        String[] typeWildcards = (String[])Arrays.stream(basePackages).map(basePackage -> basePackage + PACKAGES_AND_SUBPACKAGES_WILDCARD).toArray(String[]::new);
        xStream.allowTypesByWildcard(typeWildcards);
    }

    private XStreamSecurityTypeUtility() {
    }
}

