/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import org.axonframework.actuator.axonserver.AxonServerHealthIndicator;
import org.axonframework.actuator.axonserver.AxonServerStatusAggregator;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.springboot.autoconfig.AxonServerAutoConfiguration;
import org.springframework.boot.actuate.health.SimpleStatusAggregator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureAfter(value={AxonServerAutoConfiguration.class})
@ConditionalOnClass(name={"org.springframework.boot.actuate.health.AbstractHealthIndicator", "org.axonframework.axonserver.connector.AxonServerConnectionManager"})
@ConditionalOnProperty(name={"axon.axonserver.enabled"}, matchIfMissing=true)
public class AxonServerActuatorAutoConfiguration {
    @ConditionalOnMissingBean(value={AxonServerHealthIndicator.class})
    @Bean
    public AxonServerHealthIndicator axonServerHealthIndicator(AxonServerConnectionManager connectionManager) {
        return new AxonServerHealthIndicator(connectionManager);
    }

    @ConditionalOnMissingBean(value={SimpleStatusAggregator.class})
    @Bean
    public AxonServerStatusAggregator axonServerStatusAggregator() {
        return new AxonServerStatusAggregator();
    }
}

