/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.config.ConfigurationScopeAwareProvider;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.DeadlineManagerSpanFactory;
import org.axonframework.deadline.dbscheduler.DbSchedulerBinaryDeadlineDetails;
import org.axonframework.deadline.dbscheduler.DbSchedulerDeadlineManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerBinaryEventData;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerEventScheduler;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.serialization.Serializer;
import org.axonframework.springboot.autoconfig.AxonServerAutoConfiguration;
import org.axonframework.springboot.autoconfig.AxonTracingAutoConfiguration;
import org.axonframework.springboot.util.ConditionalOnMissingQualifiedBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnBean(value={Scheduler.class})
@AutoConfigureAfter(value={AxonServerAutoConfiguration.class, AxonTracingAutoConfiguration.class}, name={"com.github.kagkarlsson.scheduler.boot.autoconfigure.DbSchedulerAutoConfiguration"})
public class AxonDbSchedulerAutoConfiguration {
    @Bean
    @Qualifier(value="eventDataTask")
    @ConditionalOnMissingQualifiedBean(beanClass=Task.class, qualifier="eventDataTask")
    public Task<DbSchedulerBinaryEventData> dbSchedulerEventDataTask(ApplicationContext context) {
        return DbSchedulerEventScheduler.binaryTask(() -> (DbSchedulerEventScheduler)context.getBean(DbSchedulerEventScheduler.class));
    }

    @Bean
    @Qualifier(value="deadlineDetailsTask")
    @ConditionalOnMissingQualifiedBean(beanClass=Task.class, qualifier="deadlineDetailsTask")
    public Task<DbSchedulerBinaryDeadlineDetails> dbSchedulerDeadlineDetailsTask(ApplicationContext context) {
        return DbSchedulerDeadlineManager.binaryTask(() -> (DbSchedulerDeadlineManager)context.getBean(DbSchedulerDeadlineManager.class));
    }

    @Bean
    @ConditionalOnMissingBean
    public EventScheduler eventScheduler(Scheduler scheduler, @Qualifier(value="eventSerializer") Serializer serializer, TransactionManager transactionManager, EventBus eventBus) {
        return DbSchedulerEventScheduler.builder().scheduler(scheduler).serializer(serializer).transactionManager(transactionManager).eventBus(eventBus).startScheduler(false).stopScheduler(false).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public DeadlineManager deadlineManager(Scheduler scheduler, Configuration configuration, @Qualifier(value="eventSerializer") Serializer serializer, TransactionManager transactionManager, DeadlineManagerSpanFactory spanFactory) {
        ConfigurationScopeAwareProvider scopeAwareProvider = new ConfigurationScopeAwareProvider(configuration);
        return DbSchedulerDeadlineManager.builder().scheduler(scheduler).scopeAwareProvider((ScopeAwareProvider)scopeAwareProvider).serializer(serializer).transactionManager(transactionManager).spanFactory(spanFactory).startScheduler(false).stopScheduler(false).build();
    }
}

