/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="axon.tracing")
public class TracingProperties {
    private SnapshotterProperties snapshotter = new SnapshotterProperties();
    private CommandBusProperties commandBus = new CommandBusProperties();
    private QueryBusProperties queryBus = new QueryBusProperties();
    private DeadlineManagerProperties deadlineManager = new DeadlineManagerProperties();
    private SagaManagerProperties sagaManager = new SagaManagerProperties();
    private RepositoryProperties repository = new RepositoryProperties();
    private EventProcessorProperties eventProcessor = new EventProcessorProperties();
    private boolean showEventSourcingHandlers = false;
    private AttributeProviders attributeProviders;

    public SnapshotterProperties getSnapshotter() {
        return this.snapshotter;
    }

    public void setSnapshotter(SnapshotterProperties snapshotter) {
        this.snapshotter = snapshotter;
    }

    public CommandBusProperties getCommandBus() {
        return this.commandBus;
    }

    public void setCommandBus(CommandBusProperties commandBus) {
        this.commandBus = commandBus;
    }

    public QueryBusProperties getQueryBus() {
        return this.queryBus;
    }

    public void setQueryBus(QueryBusProperties queryBus) {
        this.queryBus = queryBus;
    }

    public DeadlineManagerProperties getDeadlineManager() {
        return this.deadlineManager;
    }

    public void setDeadlineManager(DeadlineManagerProperties deadlineManager) {
        this.deadlineManager = deadlineManager;
    }

    public SagaManagerProperties getSagaManager() {
        return this.sagaManager;
    }

    public void setSagaManager(SagaManagerProperties sagaManager) {
        this.sagaManager = sagaManager;
    }

    public RepositoryProperties getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryProperties repository) {
        this.repository = repository;
    }

    public EventProcessorProperties getEventProcessor() {
        return this.eventProcessor;
    }

    public void setEventProcessor(EventProcessorProperties eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    public boolean isShowEventSourcingHandlers() {
        return this.showEventSourcingHandlers;
    }

    public void setShowEventSourcingHandlers(boolean showEventSourcingHandlers) {
        this.showEventSourcingHandlers = showEventSourcingHandlers;
    }

    @Deprecated
    public boolean isNestedHandlers() {
        return this.eventProcessor.isDistributedInSameTrace();
    }

    @Deprecated
    public void setNestedHandlers(boolean nestedHandlers) {
        this.eventProcessor.setDistributedInSameTrace(nestedHandlers);
    }

    @Deprecated
    public Duration getNestedTimeLimit() {
        return this.eventProcessor.getDistributedInSameTraceTimeLimit();
    }

    @Deprecated
    public void setNestedTimeLimit(Duration nestedTimeLimit) {
        this.eventProcessor.setDistributedInSameTraceTimeLimit(nestedTimeLimit);
    }

    public AttributeProviders getAttributeProviders() {
        return this.attributeProviders;
    }

    public void setAttributeProviders(AttributeProviders attributeProviders) {
        this.attributeProviders = attributeProviders;
    }

    public static class EventProcessorProperties {
        private boolean disableBatchTrace = false;
        private boolean distributedInSameTrace = false;
        private Duration distributedInSameTraceTimeLimit = Duration.ofMinutes(2L);

        public boolean isDisableBatchTrace() {
            return this.disableBatchTrace;
        }

        public void setDisableBatchTrace(boolean disableBatchTrace) {
            this.disableBatchTrace = disableBatchTrace;
        }

        public boolean isDistributedInSameTrace() {
            return this.distributedInSameTrace;
        }

        public void setDistributedInSameTrace(boolean distributedInSameTrace) {
            this.distributedInSameTrace = distributedInSameTrace;
        }

        public Duration getDistributedInSameTraceTimeLimit() {
            return this.distributedInSameTraceTimeLimit;
        }

        public void setDistributedInSameTraceTimeLimit(Duration distributedInSameTraceTimeLimit) {
            this.distributedInSameTraceTimeLimit = distributedInSameTraceTimeLimit;
        }
    }

    public static class SagaManagerProperties {
        private String sagaIdentifierAttributeName = "axon.sagaIdentifier";

        public String getSagaIdentifierAttributeName() {
            return this.sagaIdentifierAttributeName;
        }

        public void setSagaIdentifierAttributeName(String sagaIdentifierAttributeName) {
            this.sagaIdentifierAttributeName = sagaIdentifierAttributeName;
        }
    }

    public static class RepositoryProperties {
        private String aggregateIdAttributeName = "axon.deadlineId";

        public String getAggregateIdAttributeName() {
            return this.aggregateIdAttributeName;
        }

        public void setAggregateIdAttributeName(String aggregateIdAttributeName) {
            this.aggregateIdAttributeName = aggregateIdAttributeName;
        }
    }

    public static class DeadlineManagerProperties {
        private String deadlineIdAttributeName = "axon.deadlineId";
        private String deadlineScopeAttributeName = "axon.scope";

        public String getDeadlineIdAttributeName() {
            return this.deadlineIdAttributeName;
        }

        public void setDeadlineIdAttributeName(String deadlineIdAttributeName) {
            this.deadlineIdAttributeName = deadlineIdAttributeName;
        }

        public String getDeadlineScopeAttributeName() {
            return this.deadlineScopeAttributeName;
        }

        public void setDeadlineScopeAttributeName(String deadlineScopeAttributeName) {
            this.deadlineScopeAttributeName = deadlineScopeAttributeName;
        }
    }

    public static class QueryBusProperties {
        private boolean distributedInSameTrace = true;

        public boolean isDistributedInSameTrace() {
            return this.distributedInSameTrace;
        }

        public void setDistributedInSameTrace(boolean distributedInSameTrace) {
            this.distributedInSameTrace = distributedInSameTrace;
        }
    }

    public static class CommandBusProperties {
        private boolean distributedInSameTrace = true;

        public boolean isDistributedInSameTrace() {
            return this.distributedInSameTrace;
        }

        public void setDistributedInSameTrace(boolean distributedInSameTrace) {
            this.distributedInSameTrace = distributedInSameTrace;
        }
    }

    public static class SnapshotterProperties {
        private boolean separateTrace = false;
        private boolean aggregateTypeInSpanName = true;

        public boolean isSeparateTrace() {
            return this.separateTrace;
        }

        public void setSeparateTrace(boolean separateTrace) {
            this.separateTrace = separateTrace;
        }

        public boolean isAggregateTypeInSpanName() {
            return this.aggregateTypeInSpanName;
        }

        public void setAggregateTypeInSpanName(boolean aggregateTypeInSpanName) {
            this.aggregateTypeInSpanName = aggregateTypeInSpanName;
        }
    }

    public static class AttributeProviders {
        private boolean aggregateIdentifier = true;
        private boolean messageId = true;
        private boolean messageName = true;
        private boolean messageType = true;
        private boolean metadata = true;
        private boolean payloadType = true;

        public boolean isAggregateIdentifier() {
            return this.aggregateIdentifier;
        }

        public void setAggregateIdentifier(boolean aggregateIdentifier) {
            this.aggregateIdentifier = aggregateIdentifier;
        }

        public boolean isMessageId() {
            return this.messageId;
        }

        public void setMessageId(boolean messageId) {
            this.messageId = messageId;
        }

        public boolean isMessageName() {
            return this.messageName;
        }

        public void setMessageName(boolean messageName) {
            this.messageName = messageName;
        }

        public boolean isMessageType() {
            return this.messageType;
        }

        public void setMessageType(boolean messageType) {
            this.messageType = messageType;
        }

        public boolean isMetadata() {
            return this.metadata;
        }

        public void setMetadata(boolean metadata) {
            this.metadata = metadata;
        }

        public boolean isPayloadType() {
            return this.payloadType;
        }

        public void setPayloadType(boolean payloadType) {
            this.payloadType = payloadType;
        }
    }
}

