/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventProcessorConfiguration;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.JavaSerializer;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.json.JacksonSerializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.axonframework.spring.config.AxonConfiguration;
import org.axonframework.springboot.DistributedCommandBusProperties;
import org.axonframework.springboot.EventProcessorProperties;
import org.axonframework.springboot.SerializerProperties;
import org.axonframework.springboot.autoconfig.EventProcessingAutoConfiguration;
import org.axonframework.springboot.util.ConditionalOnMissingQualifiedBean;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@org.springframework.context.annotation.Configuration
@AutoConfigureAfter(value={EventProcessingAutoConfiguration.class})
@EnableConfigurationProperties(value={EventProcessorProperties.class, DistributedCommandBusProperties.class, SerializerProperties.class})
public class AxonAutoConfiguration
implements BeanClassLoaderAware {
    private final EventProcessorProperties eventProcessorProperties;
    private final SerializerProperties serializerProperties;
    private final ApplicationContext applicationContext;
    private ClassLoader beanClassLoader;

    public AxonAutoConfiguration(EventProcessorProperties eventProcessorProperties, SerializerProperties serializerProperties, ApplicationContext applicationContext) {
        this.eventProcessorProperties = eventProcessorProperties;
        this.serializerProperties = serializerProperties;
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public RevisionResolver revisionResolver() {
        return new AnnotationRevisionResolver();
    }

    @Bean
    @Primary
    @ConditionalOnMissingQualifiedBean(beanClass=Serializer.class, qualifier="!eventSerializer,messageSerializer")
    public Serializer serializer(RevisionResolver revisionResolver) {
        return this.buildSerializer(revisionResolver, this.serializerProperties.getGeneral());
    }

    @Bean
    @Qualifier(value="messageSerializer")
    @ConditionalOnMissingQualifiedBean(beanClass=Serializer.class, qualifier="messageSerializer")
    public Serializer messageSerializer(Serializer genericSerializer, RevisionResolver revisionResolver) {
        if (SerializerProperties.SerializerType.DEFAULT.equals((Object)this.serializerProperties.getMessages()) || this.serializerProperties.getGeneral().equals((Object)this.serializerProperties.getMessages())) {
            return genericSerializer;
        }
        return this.buildSerializer(revisionResolver, this.serializerProperties.getMessages());
    }

    @Bean
    @Qualifier(value="eventSerializer")
    @ConditionalOnMissingQualifiedBean(beanClass=Serializer.class, qualifier="eventSerializer")
    public Serializer eventSerializer(@Qualifier(value="messageSerializer") Serializer messageSerializer, Serializer generalSerializer, RevisionResolver revisionResolver) {
        if (SerializerProperties.SerializerType.DEFAULT.equals((Object)this.serializerProperties.getEvents()) || this.serializerProperties.getEvents().equals((Object)this.serializerProperties.getMessages())) {
            return messageSerializer;
        }
        if (this.serializerProperties.getGeneral().equals((Object)this.serializerProperties.getEvents())) {
            return generalSerializer;
        }
        return this.buildSerializer(revisionResolver, this.serializerProperties.getEvents());
    }

    private Serializer buildSerializer(RevisionResolver revisionResolver, SerializerProperties.SerializerType serializerType) {
        switch (serializerType) {
            case JACKSON: {
                Map objectMapperBeans = this.applicationContext.getBeansOfType(ObjectMapper.class);
                ObjectMapper objectMapper = objectMapperBeans.containsKey("defaultAxonObjectMapper") ? (ObjectMapper)objectMapperBeans.get("defaultAxonObjectMapper") : (ObjectMapper)objectMapperBeans.values().stream().findFirst().orElseThrow(() -> new NoClassDefFoundError("com/fasterxml/jackson/databind/ObjectMapper"));
                ChainingConverter converter = new ChainingConverter(this.beanClassLoader);
                return JacksonSerializer.builder().revisionResolver(revisionResolver).converter((Converter)converter).objectMapper(objectMapper).build();
            }
            case JAVA: {
                return JavaSerializer.builder().revisionResolver(revisionResolver).build();
            }
        }
        XStreamSerializer xStreamSerializer = XStreamSerializer.builder().revisionResolver(revisionResolver).build();
        xStreamSerializer.getXStream().setClassLoader(this.beanClassLoader);
        return xStreamSerializer;
    }

    @Bean
    @ConditionalOnMissingBean
    public CorrelationDataProvider messageOriginProvider() {
        return new MessageOriginProvider();
    }

    @Qualifier(value="eventStore")
    @Bean(name={"eventBus"})
    @ConditionalOnMissingBean(value={EventBus.class})
    @ConditionalOnBean(value={EventStorageEngine.class})
    public EmbeddedEventStore eventStore(EventStorageEngine storageEngine, AxonConfiguration configuration) {
        return EmbeddedEventStore.builder().storageEngine(storageEngine).messageMonitor(configuration.messageMonitor(EventStore.class, "eventStore")).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public CommandGateway commandGateway(CommandBus commandBus) {
        return DefaultCommandGateway.builder().commandBus(commandBus).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public QueryGateway queryGateway(QueryBus queryBus) {
        return DefaultQueryGateway.builder().queryBus(queryBus).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={EventStorageEngine.class, EventBus.class})
    public SimpleEventBus eventBus(AxonConfiguration configuration) {
        return SimpleEventBus.builder().messageMonitor(configuration.messageMonitor(EventStore.class, "eventStore")).build();
    }

    @Autowired
    public void configureEventHandling(EventProcessingConfigurer eventProcessingConfigurer, ApplicationContext applicationContext) {
        this.eventProcessorProperties.getProcessors().forEach((k, v) -> {
            Function<Configuration, SequencingPolicy<? super EventMessage<?>>> sequencingPolicy = this.resolveSequencingPolicy(applicationContext, (EventProcessorProperties.ProcessorSettings)v);
            eventProcessingConfigurer.registerSequencingPolicy(k, sequencingPolicy);
            if (v.getMode() == EventProcessorProperties.Mode.TRACKING) {
                TrackingEventProcessorConfiguration config = TrackingEventProcessorConfiguration.forParallelProcessing((int)v.getThreadCount()).andBatchSize(v.getBatchSize()).andInitialSegmentsCount(v.getInitialSegmentCount()).andTokenClaimInterval(v.getTokenClaimInterval(), v.getTokenClaimIntervalTimeUnit());
                Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> messageSource = this.resolveMessageSource(applicationContext, (EventProcessorProperties.ProcessorSettings)v);
                eventProcessingConfigurer.registerTrackingEventProcessor(k, messageSource, c -> config);
            } else if (v.getSource() == null) {
                eventProcessingConfigurer.registerSubscribingEventProcessor(k);
            } else {
                eventProcessingConfigurer.registerSubscribingEventProcessor(k, c -> (SubscribableMessageSource)applicationContext.getBean(v.getSource(), SubscribableMessageSource.class));
            }
        });
    }

    private Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> resolveMessageSource(ApplicationContext applicationContext, EventProcessorProperties.ProcessorSettings v) {
        Function<Configuration, Object> messageSource = v.getSource() == null ? Configuration::eventStore : c -> (StreamableMessageSource)applicationContext.getBean(v.getSource(), StreamableMessageSource.class);
        return messageSource;
    }

    private Function<Configuration, SequencingPolicy<? super EventMessage<?>>> resolveSequencingPolicy(ApplicationContext applicationContext, EventProcessorProperties.ProcessorSettings v) {
        Function<Configuration, Object> sequencingPolicy = v.getSequencingPolicy() != null ? c -> (SequencingPolicy)applicationContext.getBean(v.getSequencingPolicy(), SequencingPolicy.class) : c -> SequentialPerAggregatePolicy.instance();
        return sequencingPolicy;
    }

    @ConditionalOnMissingBean(ignoredType={"org.axonframework.commandhandling.distributed.DistributedCommandBus", "org.axonframework.axonserver.connector.command.AxonServerCommandBus"}, value={CommandBus.class})
    @Qualifier(value="localSegment")
    @Bean
    public SimpleCommandBus commandBus(TransactionManager txManager, AxonConfiguration axonConfiguration) {
        SimpleCommandBus commandBus = SimpleCommandBus.builder().transactionManager(txManager).messageMonitor(axonConfiguration.messageMonitor(CommandBus.class, "commandBus")).build();
        commandBus.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor((Collection)axonConfiguration.correlationDataProviders()));
        return commandBus;
    }

    @ConditionalOnMissingBean(value={QueryBus.class, QueryInvocationErrorHandler.class})
    @Qualifier(value="localSegment")
    @Bean
    public SimpleQueryBus queryBus(AxonConfiguration axonConfiguration, TransactionManager transactionManager) {
        return SimpleQueryBus.builder().messageMonitor(axonConfiguration.messageMonitor(QueryBus.class, "queryBus")).transactionManager(transactionManager).errorHandler((QueryInvocationErrorHandler)axonConfiguration.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter((QueryUpdateEmitter)axonConfiguration.getComponent(QueryUpdateEmitter.class)).build();
    }

    @ConditionalOnBean(value={QueryInvocationErrorHandler.class})
    @ConditionalOnMissingBean(value={QueryBus.class})
    @Qualifier(value="localSegment")
    @Bean
    public SimpleQueryBus queryBus(AxonConfiguration axonConfiguration, TransactionManager transactionManager, QueryInvocationErrorHandler eh) {
        return SimpleQueryBus.builder().messageMonitor(axonConfiguration.messageMonitor(QueryBus.class, "queryBus")).transactionManager(transactionManager).errorHandler(eh).queryUpdateEmitter((QueryUpdateEmitter)axonConfiguration.getComponent(QueryUpdateEmitter.class)).build();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

