/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.boot;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManagerFactory;
import org.axonframework.amqp.eventhandling.AMQPMessageConverter;
import org.axonframework.amqp.eventhandling.DefaultAMQPMessageConverter;
import org.axonframework.amqp.eventhandling.PackageRoutingKeyResolver;
import org.axonframework.amqp.eventhandling.RoutingKeyResolver;
import org.axonframework.amqp.eventhandling.spring.SpringAMQPPublisher;
import org.axonframework.boot.AMQPProperties;
import org.axonframework.boot.EventProcessorProperties;
import org.axonframework.boot.RegisterDefaultEntities;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.commandhandling.distributed.DistributedCommandBus;
import org.axonframework.common.jpa.ContainerManagedEntityManagerProvider;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.EventHandlingConfiguration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.saga.repository.jpa.JpaSagaStore;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.jpa.JpaTokenStore;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.jpa.JpaEventStorageEngine;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.axonframework.spring.commandhandling.distributed.jgroups.JGroupsConnectorFactoryBean;
import org.axonframework.spring.config.AxonConfiguration;
import org.axonframework.spring.config.EnableAxon;
import org.axonframework.spring.config.SpringAxonAutoConfigurer;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.jgroups.stack.GossipRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.PlatformTransactionManager;

@EnableAxon
@ConditionalOnClass(value={SpringAxonAutoConfigurer.class})
@Configuration
@AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration"})
@EnableConfigurationProperties(value={EventProcessorProperties.class})
public class AxonAutoConfiguration {
    private final EventProcessorProperties eventProcessorProperties;

    public AxonAutoConfiguration(EventProcessorProperties eventProcessorProperties) {
        this.eventProcessorProperties = eventProcessorProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public Serializer serializer() {
        return new XStreamSerializer();
    }

    @Qualifier(value="eventStore")
    @Bean(value={"eventBus"})
    @ConditionalOnMissingBean(value={EventBus.class, EventStore.class})
    @ConditionalOnBean(value={EventStorageEngine.class})
    public EventStore eventStore(EventStorageEngine storageEngine, AxonConfiguration configuration) {
        return new EmbeddedEventStore(storageEngine, configuration.messageMonitor(EventStore.class, "eventStore"));
    }

    @Bean
    @ConditionalOnMissingBean(value={EventStorageEngine.class, EventBus.class, EventStore.class})
    public EventBus eventBus(AxonConfiguration configuration) {
        return new SimpleEventBus(Integer.MAX_VALUE, configuration.messageMonitor(EventStore.class, "eventStore"));
    }

    @Autowired(required=false)
    public void configureEventHandling(EventHandlingConfiguration eventHandlingConfiguration, ApplicationContext applicationContext) {
        this.eventProcessorProperties.getProcessors().forEach((k, v) -> {
            if (v.getMode() == EventProcessorProperties.Mode.TRACKING) {
                if (v.getSource() == null) {
                    eventHandlingConfiguration.registerTrackingProcessor(k);
                } else {
                    eventHandlingConfiguration.registerTrackingProcessor(k, c -> (StreamableMessageSource)applicationContext.getBean(v.getSource(), StreamableMessageSource.class));
                }
            } else if (v.getSource() == null) {
                eventHandlingConfiguration.registerSubscribingEventProcessor(k);
            } else {
                eventHandlingConfiguration.registerSubscribingEventProcessor(k, c -> (SubscribableMessageSource)applicationContext.getBean(v.getSource(), SubscribableMessageSource.class));
            }
        });
    }

    @ConditionalOnMissingBean(ignored={DistributedCommandBus.class})
    @Qualifier(value="localSegment")
    @Bean
    public CommandBus commandBus(TransactionManager txManager, AxonConfiguration axonConfiguration) {
        SimpleCommandBus commandBus = new SimpleCommandBus(txManager, axonConfiguration.messageMonitor(CommandBus.class, "commandBus"));
        commandBus.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor((Collection)axonConfiguration.correlationDataProviders()));
        return commandBus;
    }

    @ConditionalOnClass(name={"org.axonframework.jgroups.commandhandling.JGroupsConnector", "org.jgroups.JChannel"})
    @EnableConfigurationProperties(value={JGroupsProperties.class})
    @ConditionalOnProperty(value={"axon.distributed.jgroups.enabled"})
    @AutoConfigureAfter(value={JpaConfiguration.class})
    @Configuration
    public static class JGroupsConfiguration {
        private static final Logger logger = LoggerFactory.getLogger(JGroupsConfiguration.class);
        private final JGroupsProperties jGroupsProperties;

        public JGroupsConfiguration(JGroupsProperties jGroupsProperties) {
            this.jGroupsProperties = jGroupsProperties;
        }

        @ConditionalOnProperty(value={"axon.distributed.jgroups.gossip.autoStart"})
        @Bean(destroyMethod="stop")
        public GossipRouter gossipRouter() {
            Matcher matcher = Pattern.compile("([^[\\[]]*)\\[(\\d*)\\]").matcher(this.jGroupsProperties.getGossip().getHosts());
            if (matcher.find()) {
                GossipRouter gossipRouter = new GossipRouter(matcher.group(1), Integer.parseInt(matcher.group(2)));
                try {
                    gossipRouter.start();
                }
                catch (Exception e) {
                    logger.warn("Unable to autostart start embedded Gossip server: {}", (Object)e.getMessage());
                }
                return gossipRouter;
            }
            logger.error("Wrong hosts pattern, cannot start embedded Gossip Router: " + this.jGroupsProperties.getGossip().getHosts());
            return null;
        }

        @ConditionalOnMissingBean
        @Primary
        @Bean
        public DistributedCommandBus distributedCommandBus(CommandRouter router, CommandBusConnector connector) {
            DistributedCommandBus commandBus = new DistributedCommandBus(router, connector);
            commandBus.updateLoadFactor(this.jGroupsProperties.getLoadFactor());
            return commandBus;
        }

        @ConditionalOnMissingBean(value={CommandRouter.class, CommandBusConnector.class})
        @Bean
        public JGroupsConnectorFactoryBean jgroupsConnectorFactoryBean(Serializer serializer, @Qualifier(value="localSegment") CommandBus localSegment) {
            System.setProperty("jgroups.tunnel.gossip_router_hosts", this.jGroupsProperties.getGossip().getHosts());
            System.setProperty("jgroups.bind_addr", String.valueOf(this.jGroupsProperties.getBindAddr()));
            System.setProperty("jgroups.bind_port", String.valueOf(this.jGroupsProperties.getBindPort()));
            JGroupsConnectorFactoryBean jGroupsConnectorFactoryBean = new JGroupsConnectorFactoryBean();
            jGroupsConnectorFactoryBean.setClusterName(this.jGroupsProperties.getClusterName());
            jGroupsConnectorFactoryBean.setLocalSegment(localSegment);
            jGroupsConnectorFactoryBean.setSerializer(serializer);
            jGroupsConnectorFactoryBean.setConfiguration(this.jGroupsProperties.getConfigurationFile());
            return jGroupsConnectorFactoryBean;
        }

        @ConfigurationProperties(prefix="axon.distributed.jgroups")
        public static class JGroupsProperties {
            private Gossip gossip;
            private boolean enabled = false;
            private String clusterName = "Axon";
            private String configurationFile = "default_tcp_gossip.xml";
            private String bindAddr = "GLOBAL";
            private String bindPort = "7800";
            private int loadFactor = 100;

            public Gossip getGossip() {
                return this.gossip;
            }

            public void setGossip(Gossip gossip) {
                this.gossip = gossip;
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public String getClusterName() {
                return this.clusterName;
            }

            public void setClusterName(String clusterName) {
                this.clusterName = clusterName;
            }

            public String getConfigurationFile() {
                return this.configurationFile;
            }

            public void setConfigurationFile(String configurationFile) {
                this.configurationFile = configurationFile;
            }

            public String getBindAddr() {
                return this.bindAddr;
            }

            public void setBindAddr(String bindAddr) {
                this.bindAddr = bindAddr;
            }

            public String getBindPort() {
                return this.bindPort;
            }

            public void setBindPort(String bindPort) {
                this.bindPort = bindPort;
            }

            public int getLoadFactor() {
                return this.loadFactor;
            }

            public void setLoadFactor(int loadFactor) {
                this.loadFactor = loadFactor;
            }

            public static class Gossip {
                private boolean autoStart = false;
                private String hosts = "localhost[12001]";

                public boolean isAutoStart() {
                    return this.autoStart;
                }

                public void setAutoStart(boolean autoStart) {
                    this.autoStart = autoStart;
                }

                public String getHosts() {
                    return this.hosts;
                }

                public void setHosts(String hosts) {
                    this.hosts = hosts;
                }
            }
        }
    }

    @ConditionalOnClass(value={SpringAMQPPublisher.class, ConnectionFactory.class})
    @EnableConfigurationProperties(value={AMQPProperties.class})
    @Configuration
    public static class AMQPConfiguration {
        private final AMQPProperties amqpProperties;

        public AMQPConfiguration(AMQPProperties amqpProperties) {
            this.amqpProperties = amqpProperties;
        }

        @ConditionalOnMissingBean
        @Bean
        public RoutingKeyResolver routingKeyResolver() {
            return new PackageRoutingKeyResolver();
        }

        @ConditionalOnMissingBean
        @Bean
        public AMQPMessageConverter amqpMessageConverter(Serializer serializer, RoutingKeyResolver routingKeyResolver) {
            return new DefaultAMQPMessageConverter(serializer, routingKeyResolver, this.amqpProperties.isDurableMessages());
        }

        @ConditionalOnProperty(value={"axon.amqp.exchange"})
        @Bean(initMethod="start", destroyMethod="shutDown")
        public SpringAMQPPublisher amqpBridge(EventBus eventBus, ConnectionFactory connectionFactory, AMQPMessageConverter amqpMessageConverter) {
            SpringAMQPPublisher publisher = new SpringAMQPPublisher((SubscribableMessageSource)eventBus);
            publisher.setExchangeName(this.amqpProperties.getExchange());
            publisher.setConnectionFactory(connectionFactory);
            publisher.setMessageConverter(amqpMessageConverter);
            switch (this.amqpProperties.getTransactionMode()) {
                case TRANSACTIONAL: {
                    publisher.setTransactional(true);
                    break;
                }
                case PUBLISHER_ACK: {
                    publisher.setWaitForPublisherAck(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown transaction mode: " + (Object)((Object)this.amqpProperties.getTransactionMode()));
                }
            }
            return publisher;
        }
    }

    @ConditionalOnBean(value={EntityManagerFactory.class})
    @RegisterDefaultEntities(packages={"org.axonframework.eventsourcing.eventstore.jpa", "org.axonframework.eventhandling.tokenstore", "org.axonframework.eventhandling.saga.repository.jpa"})
    @Configuration
    public static class JpaConfiguration {
        @ConditionalOnMissingBean
        @Bean
        public EventStorageEngine eventStorageEngine(EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) {
            return new JpaEventStorageEngine(entityManagerProvider, transactionManager);
        }

        @ConditionalOnMissingBean
        @Bean
        public EntityManagerProvider entityManagerProvider() {
            return new ContainerManagedEntityManagerProvider();
        }

        @ConditionalOnMissingBean
        @Bean
        public TokenStore tokenStore(Serializer serializer, EntityManagerProvider entityManagerProvider) {
            return new JpaTokenStore(entityManagerProvider, serializer);
        }

        @ConditionalOnMissingBean(value={SagaStore.class})
        @Bean
        public JpaSagaStore sagaStore(Serializer serializer, EntityManagerProvider entityManagerProvider) {
            return new JpaSagaStore(serializer, entityManagerProvider);
        }
    }

    @Configuration
    @ConditionalOnClass(value={PlatformTransactionManager.class})
    @AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration"})
    public static class TransactionConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={PlatformTransactionManager.class})
        public TransactionManager axonTransactionManager(PlatformTransactionManager transactionManager) {
            return new SpringTransactionManager(transactionManager);
        }
    }

    @AutoConfigureAfter(value={TransactionConfiguration.class})
    @Configuration
    public static class DefaultTransactionConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={TransactionManager.class})
        public TransactionManager axonTransactionManager() {
            return NoTransactionManager.INSTANCE;
        }
    }
}

