/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query.subscription;

import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryUpdate;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.query.GrpcBackedResponseMessage;
import org.axonframework.axonserver.connector.query.subscription.GrpcBackedQueryUpdateMessage;
import org.axonframework.axonserver.connector.query.subscription.GrpcBackedSubscriptionQueryMessage;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.GrpcMetadataConverter;
import org.axonframework.axonserver.connector.util.GrpcMetadataSerializer;
import org.axonframework.axonserver.connector.util.GrpcObjectSerializer;
import org.axonframework.axonserver.connector.util.GrpcPayloadSerializer;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionMessageSerializer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AxonServerConfiguration configuration;
    private final Serializer messageSerializer;
    private final Serializer serializer;
    private final GrpcObjectSerializer<Object> exceptionDetailsSerializer;
    private final GrpcPayloadSerializer payloadSerializer;
    private final GrpcMetadataSerializer metadataSerializer;
    private final GrpcObjectSerializer<Object> responseTypeSerializer;

    public SubscriptionMessageSerializer(Serializer messageSerializer, Serializer serializer, AxonServerConfiguration configuration) {
        this.configuration = configuration;
        this.messageSerializer = messageSerializer;
        this.serializer = serializer;
        this.payloadSerializer = new GrpcPayloadSerializer(messageSerializer);
        this.metadataSerializer = new GrpcMetadataSerializer(new GrpcMetadataConverter(messageSerializer));
        this.responseTypeSerializer = new GrpcObjectSerializer(serializer);
        this.exceptionDetailsSerializer = new GrpcObjectSerializer(messageSerializer);
    }

    public QueryRequest serializeQuery(SubscriptionQueryMessage subscriptionQueryMessage) {
        return QueryRequest.newBuilder().setTimestamp(System.currentTimeMillis()).setMessageIdentifier(subscriptionQueryMessage.identifier()).setQuery(subscriptionQueryMessage.type().name()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).setPayload(this.payloadSerializer.apply((Message)subscriptionQueryMessage)).setResponseType(this.responseTypeSerializer.apply((Object)subscriptionQueryMessage.responseType())).putAllMetaData(this.metadataSerializer.apply(subscriptionQueryMessage.metadata())).build();
    }

    public SerializedObject serializeUpdateType(SubscriptionQueryMessage subscriptionQueryMessage) {
        return this.responseTypeSerializer.apply((Object)subscriptionQueryMessage.updatesResponseType());
    }

    public QueryUpdate serialize(SubscriptionQueryUpdateMessage subscriptionQueryUpdateMessage) {
        QueryUpdate.Builder updateMessageBuilder = QueryUpdate.newBuilder();
        if (subscriptionQueryUpdateMessage.isExceptional()) {
            Throwable exceptionResult = subscriptionQueryUpdateMessage.exceptionResult();
            updateMessageBuilder.setErrorCode(ErrorCode.getQueryExecutionErrorCode(exceptionResult).errorCode());
            updateMessageBuilder.setErrorMessage(ExceptionSerializer.serialize(this.configuration.getClientId(), exceptionResult));
            Optional optionalDetails = subscriptionQueryUpdateMessage.exceptionDetails();
            if (optionalDetails.isPresent()) {
                updateMessageBuilder.setPayload(this.exceptionDetailsSerializer.apply(optionalDetails.get()));
            } else {
                logger.warn("Serializing exception [{}] without details.", exceptionResult.getClass(), (Object)exceptionResult);
                logger.info("To share exceptional information with the recipient it is recommended to wrap the exception in a QueryExecutionException with provided details.");
            }
        } else {
            updateMessageBuilder.setPayload(this.payloadSerializer.apply((Message)subscriptionQueryUpdateMessage));
        }
        Map<String, MetaDataValue> metadata = this.metadataSerializer.apply(subscriptionQueryUpdateMessage.metadata());
        return updateMessageBuilder.putAllMetaData(metadata).setMessageIdentifier(subscriptionQueryUpdateMessage.identifier()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).build();
    }

    public SubscriptionQueryMessage deserialize(SubscriptionQuery subscriptionQuery) {
        return new GrpcBackedSubscriptionQueryMessage(subscriptionQuery, this.messageSerializer, this.serializer);
    }

    public <I> QueryResponseMessage deserialize(QueryResponse queryResponse) {
        return new GrpcBackedResponseMessage(queryResponse, this.messageSerializer);
    }

    public SubscriptionQueryUpdateMessage deserialize(QueryUpdate queryUpdate) {
        return new GrpcBackedQueryUpdateMessage(queryUpdate, this.messageSerializer);
    }
}

