/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.query.GrpcBackedQueryMessage;
import org.axonframework.axonserver.connector.query.GrpcBackedResponseMessage;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.GrpcMetadataConverter;
import org.axonframework.axonserver.connector.util.GrpcMetadataSerializer;
import org.axonframework.axonserver.connector.util.GrpcObjectSerializer;
import org.axonframework.axonserver.connector.util.GrpcPayloadSerializer;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.responsetypes.ConvertingResponseMessage;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySerializer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Serializer messageSerializer;
    private final Serializer serializer;
    private final AxonServerConfiguration configuration;
    private final GrpcObjectSerializer<Object> exceptionDetailsSerializer;
    private final GrpcPayloadSerializer payloadSerializer;
    private final GrpcMetadataSerializer metadataSerializer;
    private final GrpcObjectSerializer<Object> responseTypeSerializer;

    public QuerySerializer(Serializer messageSerializer, Serializer serializer, AxonServerConfiguration configuration) {
        this.messageSerializer = messageSerializer;
        this.serializer = serializer;
        this.configuration = configuration;
        this.payloadSerializer = new GrpcPayloadSerializer(messageSerializer);
        this.exceptionDetailsSerializer = new GrpcObjectSerializer(messageSerializer);
        this.metadataSerializer = new GrpcMetadataSerializer(new GrpcMetadataConverter(this.messageSerializer));
        this.responseTypeSerializer = new GrpcObjectSerializer(serializer);
    }

    public <Q, R> QueryRequest serializeRequest(QueryMessage queryMessage, int nrResults, long timeout, int priority) {
        return this.serializeRequest(queryMessage, nrResults, timeout, priority, false);
    }

    public <Q, R> QueryRequest serializeRequest(QueryMessage queryMessage, int nrResults, long timeout, int priority, boolean stream) {
        return QueryRequest.newBuilder().setTimestamp(System.currentTimeMillis()).setMessageIdentifier(queryMessage.identifier()).setQuery(queryMessage.type().name()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).setResponseType(this.responseTypeSerializer.apply((Object)queryMessage.responseType().forSerialization())).setPayload(this.payloadSerializer.apply((Message)queryMessage)).addProcessingInstructions(this.nrOfResults(nrResults)).addProcessingInstructions(this.timeout(timeout)).addProcessingInstructions(this.priority(priority)).addProcessingInstructions(this.supportsStreaming(stream)).putAllMetaData(this.metadataSerializer.apply(queryMessage.metadata())).build();
    }

    private ProcessingInstruction nrOfResults(int nrOfResults) {
        return ProcessingInstruction.newBuilder().setKey(ProcessingKey.NR_OF_RESULTS).setValue(MetaDataValue.newBuilder().setNumberValue((long)nrOfResults)).build();
    }

    private ProcessingInstruction timeout(long timeout) {
        return ProcessingInstruction.newBuilder().setKey(ProcessingKey.TIMEOUT).setValue(MetaDataValue.newBuilder().setNumberValue(timeout)).build();
    }

    private ProcessingInstruction priority(int priority) {
        return ProcessingInstruction.newBuilder().setKey(ProcessingKey.PRIORITY).setValue(MetaDataValue.newBuilder().setNumberValue((long)priority)).build();
    }

    private ProcessingInstruction supportsStreaming(boolean supportsStreaming) {
        return ProcessingInstruction.newBuilder().setKey(ProcessingKey.CLIENT_SUPPORTS_STREAMING).setValue(MetaDataValue.newBuilder().setBooleanValue(supportsStreaming)).build();
    }

    public QueryResponse serializeResponse(QueryResponseMessage queryResponse, String requestMessageId) {
        QueryResponse.Builder responseBuilder = QueryResponse.newBuilder();
        if (queryResponse.isExceptional()) {
            Throwable exceptionResult = queryResponse.exceptionResult();
            responseBuilder.setErrorCode(ErrorCode.getQueryExecutionErrorCode(exceptionResult).errorCode());
            responseBuilder.setErrorMessage(ExceptionSerializer.serialize(this.configuration.getClientId(), exceptionResult));
            Optional optionalDetails = queryResponse.exceptionDetails();
            if (optionalDetails.isPresent()) {
                responseBuilder.setPayload(this.exceptionDetailsSerializer.apply(optionalDetails.get()));
            } else {
                logger.warn("Serializing exception [{}] without details.", exceptionResult.getClass(), (Object)exceptionResult);
                logger.info("To share exceptional information with the recipient it is recommended to wrap the exception in a QueryExecutionException with provided details.");
            }
        } else {
            responseBuilder.setPayload(this.payloadSerializer.apply((Message)queryResponse));
        }
        return responseBuilder.putAllMetaData(this.metadataSerializer.apply(queryResponse.metadata())).setMessageIdentifier(queryResponse.identifier()).setRequestIdentifier(requestMessageId).build();
    }

    public <Q, R> QueryMessage deserializeRequest(QueryRequest queryRequest) {
        return new GrpcBackedQueryMessage(queryRequest, this.messageSerializer, this.serializer);
    }

    public <R> QueryResponseMessage deserializeResponse(QueryResponse queryResponse, ResponseType<R> expectedResponseType) {
        return new ConvertingResponseMessage(expectedResponseType, new GrpcBackedResponseMessage(queryResponse, this.messageSerializer));
    }

    public QueryResponseMessage deserializeResponse(QueryResponse queryResponse) {
        return new GrpcBackedResponseMessage(queryResponse, this.messageSerializer);
    }
}

