/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.event.dcb.ConsistencyCondition;
import io.axoniq.axonserver.grpc.event.dcb.Criterion;
import io.axoniq.axonserver.grpc.event.dcb.SourceEventsRequest;
import io.axoniq.axonserver.grpc.event.dcb.StreamEventsRequest;
import io.axoniq.axonserver.grpc.event.dcb.Tag;
import io.axoniq.axonserver.grpc.event.dcb.TagsAndNamesCriterion;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.axonframework.common.annotations.Internal;
import org.axonframework.eventsourcing.eventstore.AppendCondition;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.GlobalIndexConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.SourcingCondition;
import org.axonframework.eventstreaming.EventCriterion;
import org.axonframework.eventstreaming.StreamingCondition;
import org.axonframework.messaging.QualifiedName;

@Internal
public abstract class ConditionConverter {
    public static ConsistencyCondition convertAppendCondition(@Nonnull AppendCondition condition) {
        return ConsistencyCondition.newBuilder().setConsistencyMarker(GlobalIndexConsistencyMarker.position((ConsistencyMarker)condition.consistencyMarker())).addAllCriterion(ConditionConverter.convertEventCriterion(condition.criteria().flatten())).build();
    }

    public static SourceEventsRequest convertSourcingCondition(@Nonnull SourcingCondition condition) {
        return SourceEventsRequest.newBuilder().setFromSequence(condition.start()).addAllCriterion(ConditionConverter.convertEventCriterion(condition.criteria().flatten())).build();
    }

    public static StreamEventsRequest convertStreamingCondition(@Nonnull StreamingCondition condition) {
        return StreamEventsRequest.newBuilder().setFromSequence(condition.position().position().orElse(-1L)).addAllCriterion(ConditionConverter.convertEventCriterion(condition.criteria().flatten())).build();
    }

    private static List<Criterion> convertEventCriterion(Set<EventCriterion> eventCriterion) {
        return eventCriterion.stream().map(ConditionConverter::convertEventCriterion).toList();
    }

    private static Criterion convertEventCriterion(EventCriterion eventCriterion) {
        return Criterion.newBuilder().setTagsAndNames(TagsAndNamesCriterion.newBuilder().addAllTag(ConditionConverter.convertTags(eventCriterion.tags())).addAllName(ConditionConverter.convertTypes(eventCriterion.types())).build()).build();
    }

    private static List<Tag> convertTags(Set<org.axonframework.eventstreaming.Tag> tags) {
        return tags.stream().map(ConditionConverter::convertTag).toList();
    }

    private static Tag convertTag(org.axonframework.eventstreaming.Tag tag) {
        return Tag.newBuilder().setKey(ByteString.copyFrom((String)tag.key(), (Charset)StandardCharsets.UTF_8)).setValue(ByteString.copyFrom((String)tag.value(), (Charset)StandardCharsets.UTF_8)).build();
    }

    private static List<String> convertTypes(Set<QualifiedName> types) {
        return types.stream().map(QualifiedName::name).toList();
    }

    private ConditionConverter() {
    }
}

