/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.ManagedChannelCustomizer;
import org.axonframework.axonserver.connector.TagsConfiguration;
import org.axonframework.axonserver.connector.TopologyChangeListener;
import org.axonframework.axonserver.connector.command.AxonServerCommandBusConnector;
import org.axonframework.axonserver.connector.event.AxonServerEventStorageEngineFactory;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.PayloadConvertingCommandBusConnector;
import org.axonframework.common.FutureUtils;
import org.axonframework.configuration.ComponentDecorator;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.DecoratorDefinition;
import org.axonframework.configuration.SearchScope;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.messaging.conversion.MessageConverter;

public class AxonServerConfigurationEnhancer
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = -2147483638;

    public void enhance(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(AxonServerConfiguration.class, c -> new AxonServerConfiguration(), SearchScope.ALL).registerIfNotPresent(this.connectionManagerDefinition(), SearchScope.ALL).registerIfNotPresent(ManagedChannelCustomizer.class, c -> ManagedChannelCustomizer.identity(), SearchScope.ALL).registerIfNotPresent(this.eventStorageEngineDefinition(), SearchScope.ALL).registerIfNotPresent(this.commandBusConnectorDefinition(), SearchScope.ALL).registerDecorator(CommandBusConnector.class, 0, this.payloadConvertingConnectorComponentDecorator()).registerDecorator(this.topologyChangeListenerRegistration()).registerFactory((ComponentFactory)new AxonServerEventStorageEngineFactory());
    }

    private ComponentDefinition<AxonServerConnectionManager> connectionManagerDefinition() {
        return ComponentDefinition.ofType(AxonServerConnectionManager.class).withBuilder(this::buildConnectionManager).onStart(0x40000009, AxonServerConnectionManager::start).onShutdown(-134217728, AxonServerConnectionManager::shutdown);
    }

    private AxonServerConnectionManager buildConnectionManager(Configuration config) {
        AxonServerConfiguration serverConfig = (AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class);
        return AxonServerConnectionManager.builder().routingServers(serverConfig.getServers()).axonServerConfiguration(serverConfig).tagsConfiguration((TagsConfiguration)config.getComponent(TagsConfiguration.class, TagsConfiguration::new)).channelCustomizer((UnaryOperator)config.getComponent(ManagedChannelCustomizer.class)).build();
    }

    private ComponentDefinition<EventStorageEngine> eventStorageEngineDefinition() {
        return ComponentDefinition.ofType(EventStorageEngine.class).withBuilder(config -> {
            String defaultContext = ((AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class)).getContext();
            return AxonServerEventStorageEngineFactory.constructForContext(defaultContext, config);
        });
    }

    private ComponentDefinition<CommandBusConnector> commandBusConnectorDefinition() {
        return ComponentDefinition.ofType(CommandBusConnector.class).withBuilder(config -> new AxonServerCommandBusConnector(((AxonServerConnectionManager)config.getComponent(AxonServerConnectionManager.class)).getConnection(), (AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class))).onStart(0x1FFFFFFF, connector -> ((AxonServerCommandBusConnector)connector).start()).onShutdown(0x1FFFFFFF, (config, connector) -> ((AxonServerCommandBusConnector)connector).disconnect()).onShutdown(0, (config, connector) -> ((AxonServerCommandBusConnector)connector).shutdownDispatching());
    }

    private ComponentDecorator<CommandBusConnector, PayloadConvertingCommandBusConnector> payloadConvertingConnectorComponentDecorator() {
        return (config, name, delegate) -> new PayloadConvertingCommandBusConnector(delegate, (MessageConverter)config.getComponent(MessageConverter.class), byte[].class);
    }

    private DecoratorDefinition<AxonServerConnectionManager, AxonServerConnectionManager> topologyChangeListenerRegistration() {
        return DecoratorDefinition.forType(AxonServerConnectionManager.class).with((config, name, delegate) -> delegate).onStart(0x40000009, (config, connectionManager) -> {
            Optional topologyChangeListener = config.getOptionalComponent(TopologyChangeListener.class);
            topologyChangeListener.ifPresent(changeListener -> connectionManager.getConnection().controlChannel().registerTopologyChangeHandler((Consumer)changeListener));
            return FutureUtils.emptyCompletedFuture();
        });
    }

    public int order() {
        return -2147483638;
    }
}

