/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.ErrorMessage;
import io.axoniq.axonserver.grpc.SerializedObject;
import java.util.Optional;
import java.util.function.Predicate;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.common.AxonException;
import org.axonframework.common.ObjectUtils;

public final class ExceptionConverter {
    public static AxonException convertToAxonException(String errorCode, ErrorMessage errorMessage, SerializedObject payload) {
        return ErrorCode.getFromCode(errorCode).convert(errorMessage, () -> Optional.ofNullable(payload).map(SerializedObject::getData).filter(Predicate.not(ByteString::isEmpty)).map(ByteString::toByteArray).orElse(null));
    }

    public static ErrorMessage convertToErrorMessage(String clientLocation, Throwable t) {
        ErrorMessage.Builder builder = ErrorMessage.newBuilder().setLocation((String)ObjectUtils.getOrDefault((Object)clientLocation, (Object)"")).setMessage(t.getMessage() == null ? t.getClass().getName() : t.getMessage());
        builder.addDetails(t.getMessage() == null ? t.getClass().getName() : t.getMessage());
        while (t.getCause() != null) {
            builder.addDetails((t = t.getCause()).getMessage() == null ? t.getClass().getName() : t.getMessage());
        }
        return builder.build();
    }

    private ExceptionConverter() {
    }
}

