/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.grpc.MetaDataValue;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.common.annotations.Internal;

@Internal
public final class MetadataConverter {
    private MetadataConverter() {
    }

    @Nonnull
    public static Map<String, MetaDataValue> convertGrpcToMetadataValues(@Nonnull Map<String, String> source) {
        HashMap<String, MetaDataValue> result = new HashMap<String, MetaDataValue>();
        source.forEach((k, v) -> {
            MetaDataValue convertedValue = MetadataConverter.convertToTextMetaDataValue(v);
            result.put((String)k, convertedValue);
        });
        return result;
    }

    private static MetaDataValue convertToTextMetaDataValue(String value) {
        return MetaDataValue.newBuilder().setTextValue(value).build();
    }

    @Nonnull
    public static Map<String, String> convertMetadataValuesToGrpc(@Nonnull Map<String, MetaDataValue> source) {
        HashMap<String, String> result = new HashMap<String, String>();
        source.forEach((k, v) -> {
            String convertedValue = MetadataConverter.convertFromMetaDataValue(v);
            if (convertedValue != null) {
                result.put((String)k, convertedValue);
            }
        });
        return result;
    }

    private static String convertFromMetaDataValue(MetaDataValue value) {
        return switch (value.getDataCase()) {
            case MetaDataValue.DataCase.TEXT_VALUE -> value.getTextValue();
            case MetaDataValue.DataCase.DOUBLE_VALUE -> Double.toString(value.getDoubleValue());
            case MetaDataValue.DataCase.NUMBER_VALUE -> Long.toString(value.getNumberValue());
            case MetaDataValue.DataCase.BOOLEAN_VALUE -> Boolean.toString(value.getBooleanValue());
            default -> null;
        };
    }
}

