/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;

public abstract class ProcessingInstructionHelper {
    private ProcessingInstructionHelper() {
    }

    public static ProcessingInstruction.Builder createProcessingInstruction(@Nonnull ProcessingKey key, @Nonnull MetaDataValue.Builder value) {
        return ProcessingInstruction.newBuilder().setKey(key).setValue(value);
    }

    public static String routingKey(@Nonnull List<ProcessingInstruction> instructions) {
        return ProcessingInstructionHelper.getProcessingInstructionString(instructions, ProcessingKey.ROUTING_KEY).orElse(null);
    }

    private static Optional<String> getProcessingInstructionString(List<ProcessingInstruction> instructions, ProcessingKey processingKey) {
        return instructions.stream().filter(instruction -> processingKey.equals((Object)instruction.getKey())).map(instruction -> instruction.getValue().getTextValue()).findFirst();
    }

    public static int priority(@Nonnull List<ProcessingInstruction> instructions) {
        return ProcessingInstructionHelper.getProcessingInstructionNumber(instructions, ProcessingKey.PRIORITY).orElse(0L).intValue();
    }

    public static long numberOfResults(@Nonnull List<ProcessingInstruction> instructions) {
        return ProcessingInstructionHelper.getProcessingInstructionNumber(instructions, ProcessingKey.NR_OF_RESULTS).orElse(1L);
    }

    public static boolean axonServerSupportsQueryStreaming(@Nonnull List<ProcessingInstruction> instructions) {
        return ProcessingInstructionHelper.getProcessingInstructionBoolean(instructions, ProcessingKey.SERVER_SUPPORTS_STREAMING).orElse(false);
    }

    public static boolean clientSupportsQueryStreaming(@Nonnull List<ProcessingInstruction> instructions) {
        return ProcessingInstructionHelper.getProcessingInstructionBoolean(instructions, ProcessingKey.CLIENT_SUPPORTS_STREAMING).orElse(false);
    }

    private static Optional<Boolean> getProcessingInstructionBoolean(List<ProcessingInstruction> instructions, ProcessingKey processingKey) {
        return instructions.stream().filter(instruction -> processingKey.equals((Object)instruction.getKey())).map(instruction -> instruction.getValue().getBooleanValue()).findFirst();
    }

    public static long timeout(@Nonnull List<ProcessingInstruction> instructions) {
        return ProcessingInstructionHelper.getProcessingInstructionNumber(instructions, ProcessingKey.TIMEOUT).orElse(0L);
    }

    private static Optional<Long> getProcessingInstructionNumber(List<ProcessingInstruction> instructions, ProcessingKey processingKey) {
        return instructions.stream().filter(instruction -> processingKey.equals((Object)instruction.getKey())).map(instruction -> instruction.getValue().getNumberValue()).findFirst();
    }
}

